/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.mail;

import aurora.database.service.SqlServiceContext;
import aurora.plugin.mail.SendMail;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IConfigurable;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class AutoSendMail
extends AbstractEntry
implements IConfigurable {
    private IObjectRegistry registry;
    private String title;
    private String content;
    private String smtpServer;
    private String password;
    private String userName;
    private String tto;
    private String cto;
    private String from;
    private String port = "25";

    public AutoSendMail(IObjectRegistry registry) {
        this.registry = registry;
    }

    public void run(ProcedureRunner runner) throws Exception {
        ILogger logger = LoggingContext.getLogger((String)"aurora.plugin.mail", (IObjectRegistry)this.registry);
        logger.log(Level.INFO, "Accept to E-mail message, began sendind mail operation");
        CompositeMap map = runner.getContext();
        SqlServiceContext svcContext = SqlServiceContext.createSqlServiceContext((CompositeMap)map);
        CompositeMap current_param = svcContext.getCurrentParameter();
        SendMail sendMail = new SendMail();
        sendMail.setCto(TextParser.parse((String)this.cto, (CompositeMap)current_param));
        sendMail.setPassword(TextParser.parse((String)this.password, (CompositeMap)current_param));
        sendMail.setSmtpServer(TextParser.parse((String)this.smtpServer, (CompositeMap)current_param));
        sendMail.setTcontent(TextParser.parse((String)this.content, (CompositeMap)current_param));
        sendMail.setTfrom(TextParser.parse((String)this.from, (CompositeMap)current_param));
        sendMail.setTtitle(TextParser.parse((String)this.title, (CompositeMap)current_param));
        sendMail.setTto(TextParser.parse((String)this.tto, (CompositeMap)current_param));
        sendMail.setPort(this.port);
        sendMail.setUserName(TextParser.parse((String)this.userName, (CompositeMap)current_param));
        try {
            sendMail.check();
            sendMail.sendMail();
            current_param.put((Object)"status", (Object)"SUCCESS");
            logger.log(Level.INFO, "Mail send successfully!");
        }
        catch (Exception e) {
            current_param.put((Object)"status", (Object)"FAILED");
            current_param.put((Object)"message", (Object)e.getMessage());
            logger.log(Level.WARNING, e.getMessage());
        }
    }

    public IObjectRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(IObjectRegistry registry) {
        this.registry = registry;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTto() {
        return this.tto;
    }

    public void setTto(String tto) {
        this.tto = tto;
    }

    public String getCto() {
        return this.cto;
    }

    public void setCto(String cto) {
        this.cto = cto;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

