/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.ldap;

import aurora.application.util.LanguageUtil;
import aurora.plugin.ldap.LdapConfig;
import aurora.plugin.ldap.LdapServerInstance;
import aurora.service.ServiceContext;
import aurora.service.validation.ErrorMessage;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class LdapAuthentication
extends AbstractEntry {
    LdapConfig ldapMap;
    String serverName;
    String username;
    String password;
    String errorMessage;
    boolean is_ssl = false;
    IObjectRegistry mObjectRegistry;

    public LdapAuthentication(LdapConfig ldapMap, IObjectRegistry reg) {
        this.ldapMap = ldapMap;
        this.mObjectRegistry = reg;
    }

    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        this.validateParameter(context);
        LdapServerInstance ldapServer = this.ldapMap.getSapInstance(this.serverName);
        if ("ssl".equalsIgnoreCase(ldapServer.getSecurityProtocol())) {
            this.is_ssl = true;
        }
        String user = this.getUsername().indexOf(ldapServer.getDomain()) > 0 ? this.getUsername() : this.getUsername() + ldapServer.getDomain();
        String url = "ldap://" + ldapServer.getHost() + ":" + ldapServer.getPort();
        if (this.is_ssl) {
            url = "ldaps://" + ldapServer.getHost() + ":" + ldapServer.getPort();
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", ldapServer.getInitialContextFactory());
        env.put("java.naming.provider.url", url);
        env.put("java.naming.security.authentication", ldapServer.getSecurityAuthentication());
        env.put("java.naming.security.principal", user);
        env.put("java.naming.security.credentials", this.getPassword());
        if (this.is_ssl) {
            env.put("java.naming.security.protocol", ldapServer.getSecurityProtocol());
            if (ldapServer.getKeystore() == null) {
                throw new IllegalStateException("javax.net.ssl.trustStore is null");
            }
            System.setProperty("javax.net.ssl.trustStore", ldapServer.getKeystore());
        }
        InitialLdapContext ctx = null;
        try {
            ctx = new InitialLdapContext(env, null);
            ctx.close();
        }
        catch (NamingException e) {
            if (e.getMessage().startsWith("[LDAP: error code 49")) {
                String error_message = this.getErrorMessage();
                error_message = LanguageUtil.getTranslatedMessage((IObjectRegistry)this.mObjectRegistry, (String)error_message, (CompositeMap)context);
                ErrorMessage msg = new ErrorMessage(null, error_message, null);
                ServiceContext sc = ServiceContext.createServiceContext((CompositeMap)context);
                sc.setError(msg.getObjectContext());
                sc.put((Object)"success", (Object)false);
                runner.getCaller().locateTo("CreateResponse");
                runner.stop();
            }
            throw e;
        }
    }

    void validateParameter(CompositeMap context) {
        this.username = TextParser.parse((String)this.username, (CompositeMap)context);
        if (this.username == null) {
            throw new IllegalStateException("parameter \"username\" is null");
        }
        this.password = TextParser.parse((String)this.password, (CompositeMap)context);
        if (this.password == null) {
            throw new IllegalStateException("parameter \"password\" is null");
        }
        this.serverName = TextParser.parse((String)this.serverName, (CompositeMap)context);
        if (this.serverName == null) {
            throw new IllegalStateException("parameter \"serverName\" is null");
        }
        this.errorMessage = TextParser.parse((String)this.errorMessage, (CompositeMap)context);
        if (this.errorMessage == null) {
            throw new IllegalStateException("parameter \"errorMessage\" is null");
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

