/*
 * Decompiled with CFR 0.152.
 */
package uncertain.util.template;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import uncertain.util.QuickTagParser;
import uncertain.util.TagParseHandle;
import uncertain.util.template.ErrorTag;
import uncertain.util.template.ITagContent;
import uncertain.util.template.ITagCreator;
import uncertain.util.template.ITagCreatorRegistry;
import uncertain.util.template.TagCreatorRegistry;
import uncertain.util.template.TextTemplate;

public class TagTemplateParser {
    ITagCreatorRegistry mDefaultRegistry = TagCreatorRegistry.getInstance();

    public void setDefaultRegistry(ITagCreatorRegistry reg) {
        this.mDefaultRegistry = reg;
    }

    public TextTemplate buildTemplate(InputStream is) throws IOException {
        return this.buildTemplate(is, this.mDefaultRegistry);
    }

    public TextTemplate buildTemplate(InputStream is, ITagCreatorRegistry reg) throws IOException {
        return this.buildTemplate(null, is, reg);
    }

    public TextTemplate buildTemplate(String source_name, InputStream is, ITagCreatorRegistry reg) throws IOException {
        return this.buildTemplate(source_name, new InputStreamReader(is), reg);
    }

    public TextTemplate buildTemplate(Reader reader) throws IOException {
        return this.buildTemplate(null, reader, this.mDefaultRegistry);
    }

    public TextTemplate buildTemplate(Reader reader, ITagCreatorRegistry registry) throws IOException {
        return this.buildTemplate(null, reader, registry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextTemplate buildTemplate(File template_file, ITagCreatorRegistry registry) throws IOException {
        FileInputStream fis = new FileInputStream(template_file);
        InputStreamReader reader = new InputStreamReader((InputStream)fis, "utf-8");
        try {
            TextTemplate textTemplate = this.buildTemplate(template_file.getPath(), reader, registry);
            return textTemplate;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public TextTemplate buildTemplate(File template_file) throws IOException {
        return this.buildTemplate(template_file, this.mDefaultRegistry);
    }

    public TextTemplate buildTemplate(String source_file_name, Reader reader, ITagCreatorRegistry registry) throws IOException {
        QuickTagParser parser = new QuickTagParser();
        ParseHandle handle = new ParseHandle(registry);
        handle.setSourceName(source_file_name);
        parser.parse(reader, (TagParseHandle)handle);
        parser.clear();
        handle.finish();
        return handle.mTemplate;
    }

    public TextTemplate buildTemplate(String content) throws IOException {
        return this.buildTemplate(new StringReader(content));
    }

    private static class ParseHandle
    implements TagParseHandle {
        TextTemplate mTemplate = new TextTemplate();
        StringBuffer mBuf = null;
        ITagCreatorRegistry mRegistry;
        String mSourceName;

        public ParseHandle(ITagCreatorRegistry registry) {
            this.mRegistry = registry;
        }

        public void setSourceName(String name) {
            this.mSourceName = name;
            this.mTemplate.setSourceName(name);
        }

        @Override
        public String ProcessTag(int index, String tag) {
            if (this.mBuf != null) {
                this.mTemplate.addContent(this.mBuf.toString());
                this.mBuf.setLength(0);
            }
            String name_space = null;
            String tag_content = tag;
            int id = tag.indexOf(58);
            if (id > 0) {
                name_space = tag.substring(0, id);
                tag_content = tag.substring(id + 1);
            }
            ITagCreator creator = this.mRegistry.getTagCreator(name_space);
            ITagContent tc = null;
            if (creator != null) {
                tc = creator.createInstance(name_space, tag_content);
                if (tc == null) {
                    tc = new ErrorTag(this.mSourceName, 0, 0, "Unknown tag:" + tag);
                }
            } else {
                tc = new ErrorTag(this.mSourceName, 0, 0, "Unknown tag:" + tag);
            }
            this.mTemplate.addContent(tc);
            return null;
        }

        @Override
        public int ProcessCharacter(int index, char ch) {
            if (this.mBuf == null) {
                this.mBuf = new StringBuffer();
            }
            this.mBuf.append(ch);
            return -1;
        }

        public void finish() {
            if (this.mBuf != null && this.mBuf.length() > 0) {
                this.mTemplate.addContent(this.mBuf.toString());
            }
        }
    }
}

