/*
 * Decompiled with CFR 0.152.
 */
package uncertain.schema;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uncertain.composite.QualifiedName;
import uncertain.schema.Array;
import uncertain.schema.Attribute;
import uncertain.schema.Category;
import uncertain.schema.ComplexType;
import uncertain.schema.Editor;
import uncertain.schema.Element;
import uncertain.schema.IHasReference;
import uncertain.schema.IQualifiedNamed;
import uncertain.schema.IReference;
import uncertain.schema.ISchemaManager;
import uncertain.schema.IType;
import uncertain.schema.SchemaError;
import uncertain.schema.SimpleType;
import uncertain.schema.Wizard;

class NamedObjectManager {
    Map[] mChildMapArray = new Map[10];
    List mReference = new LinkedList();

    public NamedObjectManager() {
        for (int i = 0; i < this.mChildMapArray.length; ++i) {
            this.mChildMapArray[i] = new HashMap();
        }
    }

    public void addNamedObject(int type, IQualifiedNamed obj) {
        IReference ref;
        assert (type >= 0 && type < this.mChildMapArray.length && obj != null);
        QualifiedName key = obj.getQName();
        if (obj instanceof IReference && (ref = (IReference)((Object)obj)).isRef()) {
            key = ref.getRefQName();
        }
        if (key == null) {
            throw new SchemaError("Qualified name is not set for object " + obj);
        }
        this.mChildMapArray[type].put(key, obj);
        if (obj instanceof IHasReference) {
            this.mReference.add(obj);
        }
    }

    public Map getObjectMap(int type) {
        assert (type >= 0 && type < this.mChildMapArray.length);
        return this.mChildMapArray[type];
    }

    public void putAll(NamedObjectManager another) {
        assert (another != null);
        for (int i = 0; i < this.mChildMapArray.length; ++i) {
            this.mChildMapArray[i].putAll(another.mChildMapArray[i]);
        }
    }

    public Attribute getAttribute(QualifiedName qname) {
        return (Attribute)this.mChildMapArray[1].get(qname);
    }

    public Element getElement(QualifiedName qname) {
        IType type = this.getType(qname);
        if (type == null) {
            return null;
        }
        if (type instanceof Element) {
            return (Element)type;
        }
        throw new IllegalArgumentException("Specified QName {" + qname + "} is not Element but " + type.getClass().getName());
    }

    public Array getArray(QualifiedName qname) {
        Element elm = this.getElement(qname);
        if (elm.isArray()) {
            return (Array)elm;
        }
        throw new IllegalArgumentException("Specified QName {" + qname + "} is not Array but ");
    }

    public ComplexType getComplexType(QualifiedName qname) {
        IType type = this.getType(qname);
        if (type == null) {
            return null;
        }
        if (type instanceof ComplexType) {
            return (ComplexType)type;
        }
        throw new IllegalArgumentException("Specified QName {" + qname + "} is not ComplexType but " + type.getClass().getName());
    }

    public SimpleType getSimpleType(QualifiedName qname) {
        IType type = this.getType(qname);
        if (type == null) {
            return null;
        }
        if (type instanceof SimpleType) {
            return (SimpleType)type;
        }
        throw new IllegalArgumentException("Specified QName {" + qname + "} is not SimpleType but " + type.getClass().getName());
    }

    public IType getType(QualifiedName qname) {
        IType type = (IType)this.mChildMapArray[0].get(qname);
        return type;
    }

    public Category getCategory(QualifiedName qname) {
        return (Category)this.mChildMapArray[2].get(qname);
    }

    public Editor getEditor(QualifiedName qname) {
        return (Editor)this.mChildMapArray[3].get(qname);
    }

    public Wizard getWizard(QualifiedName qname) {
        return (Wizard)this.mChildMapArray[4].get(qname);
    }

    public void addAttributes(Attribute[] attribs) {
        if (attribs != null) {
            for (int i = 0; i < attribs.length; ++i) {
                this.addNamedObject(1, attribs[i]);
            }
        }
    }

    public void addElements(Element[] elements) {
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                this.addNamedObject(0, elements[i]);
            }
        }
    }

    public void addAll(NamedObjectManager another) {
        for (int i = 0; i < this.mChildMapArray.length; ++i) {
            this.mChildMapArray[i].putAll(another.mChildMapArray[i]);
        }
    }

    public void resolveReference(ISchemaManager manager) {
        for (IHasReference ref : this.mReference) {
            ref.resolveReference(manager);
        }
        Collection types = this.mChildMapArray[0].values();
        for (Object o : types) {
            if (!(o instanceof ComplexType)) continue;
            ComplexType type = (ComplexType)o;
            type.resolveReference(manager);
        }
    }
}

