/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.IChildContainerAcceptable;
import uncertain.proc.AbstractEntry;
import uncertain.proc.Action;
import uncertain.proc.Assert;
import uncertain.proc.IEntry;
import uncertain.proc.Loop;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;
import uncertain.proc.Set;
import uncertain.proc.Switch;

public abstract class EntryList
extends AbstractEntry
implements IChildContainerAcceptable {
    LinkedList entry_list;
    Map entry_map;

    private void checkMap() {
        if (this.entry_map == null) {
            this.entry_map = new HashMap();
        }
    }

    public void addEntry(IEntry e) {
        if (this.entry_list == null) {
            this.entry_list = new LinkedList();
        }
        this.entry_list.add(e);
        String n = e.getName();
        if (n != null) {
            this.checkMap();
            this.entry_map.put(n, e);
        }
        if (e instanceof EntryList) {
            EntryList l = (EntryList)e;
            Map m = l.getEntryMap();
            if (m != null) {
                this.checkMap();
                this.entry_map.putAll(m);
                m.clear();
            }
            l.setEntryMap(this.entry_map);
        }
        e.setOwner(this);
    }

    public IEntry getNamedEntry(String name) {
        if (this.entry_map == null) {
            return null;
        }
        return (IEntry)this.entry_map.get(name);
    }

    public ListIterator locateNamedEntry(String name) {
        return this.locateEntry(this.getNamedEntry(name));
    }

    public ListIterator locateEntry(IEntry e) {
        if (e == null) {
            return null;
        }
        int idx = this.entry_list.indexOf(e);
        if (idx < 0) {
            return null;
        }
        return this.entry_list.listIterator(idx);
    }

    public List getEntryList() {
        return this.entry_list;
    }

    protected Map getEntryMap() {
        return this.entry_map;
    }

    protected void setEntryMap(Map m) {
        this.entry_map = m;
    }

    public void addAction(Action a) {
        this.addEntry(a);
    }

    public void addProcedure(Procedure p) {
        this.addEntry(p);
    }

    public void addSwitch(Switch ch) {
        this.addEntry(ch);
    }

    public void addSet(Set s) {
        this.addEntry(s);
    }

    public void addLoop(Loop l) {
        this.addEntry(l);
    }

    public void addAssert(Assert a) {
        this.addEntry(a);
    }

    @Override
    public void addChild(CompositeMap child) {
        throw BuiltinExceptionFactory.createUnknownChild(child);
    }

    public void clear() {
        if (this.entry_list != null) {
            this.entry_list.clear();
        }
        if (this.entry_map != null) {
            this.entry_map.clear();
        }
    }

    @Override
    public abstract void run(ProcedureRunner var1) throws Exception;
}

