/*
 * Decompiled with CFR 0.152.
 */
package uncertain.exception;

import java.io.File;
import uncertain.composite.CompositeMap;
import uncertain.exception.ICodedException;
import uncertain.exception.MessageFactory;
import uncertain.proc.trace.IWithProcedureStackTrace;
import uncertain.proc.trace.TraceElement;
import uncertain.util.resource.ILocatable;
import uncertain.util.resource.Location;

public abstract class BaseException
extends Exception
implements ILocatable,
ICodedException,
IWithProcedureStackTrace {
    protected Location location;
    protected String sourceFile;
    protected String code;
    protected TraceElement traceElement;

    protected BaseException(String message, Throwable cause) {
        super(message, cause);
    }

    protected BaseException(String message) {
        super(message);
    }

    protected BaseException(Throwable cause) {
        super(cause);
    }

    public BaseException(String code, Object[] args, Throwable cause) {
        this(MessageFactory.getMessage(code, args), cause);
        this.setCode(code);
    }

    public BaseException(String code, Object[] args, Throwable cause, CompositeMap config) {
        this(MessageFactory.getMessage(code, args), cause);
        this.setCauseConfig(config);
        this.setCode(code);
    }

    public BaseException(String code, Object[] args, Throwable cause, String source, Location location) {
        this(MessageFactory.getMessage(code, args), cause);
        this.setSource(source);
        this.setOriginLocation(location);
        this.setCode(code);
    }

    public BaseException(String code, Object[] args, Throwable cause, ILocatable location) {
        this(code, args, cause, location.getOriginSource(), location.getOriginLocation());
    }

    public BaseException(String code, Object[] args, ILocatable location) {
        this(code, args, null, location);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public Location getOriginLocation() {
        return this.location;
    }

    public void setOriginLocation(Location location) {
        this.location = location;
    }

    @Override
    public String getOriginSource() {
        return this.sourceFile;
    }

    public void setSource(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void setCauseConfig(CompositeMap config) {
        this.location = config.getLocation();
        File file = config.getSourceFile();
        this.sourceFile = file == null ? null : file.getAbsolutePath();
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        return MessageFactory.getExceptionMessage(this, msg);
    }

    @Override
    public TraceElement getTraceElement() {
        return this.traceElement;
    }

    @Override
    public void setTraceElement(TraceElement traceElement) {
        this.traceElement = traceElement;
    }
}

