/*
 * Decompiled with CFR 0.152.
 */
package uncertain.cache;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import uncertain.cache.CacheMapping;
import uncertain.cache.CacheWrapper;
import uncertain.cache.ICache;
import uncertain.cache.ICacheFactory;
import uncertain.cache.ICacheProvider;
import uncertain.cache.ICacheReader;
import uncertain.cache.ICacheWriter;
import uncertain.cache.INamedCacheFactory;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;
import uncertain.core.ConfigurationError;
import uncertain.core.IGlobalInstance;
import uncertain.core.ILifeCycle;
import uncertain.core.UncertainEngine;
import uncertain.event.IContextListener;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.util.FilePatternFilter;
import uncertain.util.FileUtil;

public class CacheFactoryConfig
implements INamedCacheFactory,
ILifeCycle {
    private static final CacheWrapper NOT_ENABLED_CACHE = new CacheWrapper();
    String mName;
    String cacheConfig = "cacheConfig";
    INamedCacheFactory mDefaultCacheFactory;
    String mDefaultCacheFactoryName;
    INamedCacheFactory[] mNamedCacheFactoryArray;
    CacheMapping[] mCacheMappingArray;
    Map mCacheFactoryMap = new HashMap();
    Map mPredefinedCacheMap = new HashMap();
    IObjectRegistry mRegistry;
    ILogger mLogger;
    UncertainEngine mEngine;
    List<ILifeCycle> mLoadedLifeCycleList = new LinkedList<ILifeCycle>();
    Set<ICacheProvider> cacheProviderSet = new HashSet<ICacheProvider>();

    public static ICache getNamedCache(IObjectRegistry reg, String name) {
        INamedCacheFactory fact = (INamedCacheFactory)reg.getInstanceOfType(INamedCacheFactory.class);
        if (fact != null) {
            if (!fact.isCacheEnabled(name)) {
                return null;
            }
            return fact.getNamedCache(name);
        }
        return null;
    }

    public CacheFactoryConfig() {
    }

    public CacheFactoryConfig(IObjectRegistry reg) {
        this.mRegistry = reg;
        reg.registerInstance(INamedCacheFactory.class, this);
        reg.registerInstance(ICacheFactory.class, this);
    }

    public String getDefaultCacheFactory() {
        return this.mDefaultCacheFactoryName;
    }

    public void setDefaultCacheFactory(String mDefaultCacheFactory) {
        this.mDefaultCacheFactoryName = mDefaultCacheFactory;
    }

    @Override
    public ICacheReader getCacheReader() {
        return this.mDefaultCacheFactory == null ? null : this.mDefaultCacheFactory.getCacheReader();
    }

    @Override
    public ICacheWriter getCacheWriter() {
        return this.mDefaultCacheFactory == null ? null : this.mDefaultCacheFactory.getCacheWriter();
    }

    @Override
    public ICache getCache() {
        return this.mDefaultCacheFactory == null ? null : this.mDefaultCacheFactory.getCache();
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    @Override
    public ICache getNamedCache(String name) {
        Object o = this.mPredefinedCacheMap.get(name);
        if (o == null) {
            return this.mDefaultCacheFactory == null ? null : this.mDefaultCacheFactory.getNamedCache(name);
        }
        if (NOT_ENABLED_CACHE.equals(o)) {
            return null;
        }
        return ((INamedCacheFactory)o).getNamedCache(name);
    }

    public void addCacheFactories(INamedCacheFactory[] factories) {
        this.mNamedCacheFactoryArray = factories;
    }

    public void addCacheMappings(CacheMapping[] mappings) {
        this.mCacheMappingArray = mappings;
    }

    @Override
    public boolean startup() {
        int i;
        this.mLogger = LoggingContext.getLogger(this.getClass().getCanonicalName(), this.mRegistry);
        for (i = 0; i < this.mNamedCacheFactoryArray.length; ++i) {
            this.mCacheFactoryMap.put(this.mNamedCacheFactoryArray[i].getName(), this.mNamedCacheFactoryArray[i]);
        }
        for (i = 0; i < this.mCacheMappingArray.length; ++i) {
            CacheMapping cm = this.mCacheMappingArray[i];
            INamedCacheFactory fact = (INamedCacheFactory)this.mCacheFactoryMap.get(cm.getCacheFactory());
            if (fact == null) {
                throw new ConfigurationError("Can't find cache factory named " + cm.getCacheFactory());
            }
            if (!cm.getEnabled()) {
                this.mPredefinedCacheMap.put(cm.getName(), NOT_ENABLED_CACHE);
                continue;
            }
            this.mPredefinedCacheMap.put(cm.getName(), fact);
        }
        if (this.mDefaultCacheFactoryName != null) {
            this.mDefaultCacheFactory = (INamedCacheFactory)this.mCacheFactoryMap.get(this.mDefaultCacheFactoryName);
            if (this.mDefaultCacheFactory == null) {
                throw new ConfigurationError("Can't find cache factory named " + this.mDefaultCacheFactoryName);
            }
        }
        if (this.cacheConfig != null) {
            if (this.mRegistry == null) {
                throw new IllegalStateException("Field IObjectRegistry can't be null");
            }
            this.mEngine = (UncertainEngine)this.mRegistry.getInstanceOfType(UncertainEngine.class);
            if (this.mEngine == null) {
                throw BuiltinExceptionFactory.createInstanceNotFoundException(null, UncertainEngine.class);
            }
            File cacheConfigDir = new File(this.mEngine.getConfigDirectory(), this.cacheConfig);
            if (cacheConfigDir.exists()) {
                this.scanConfigFiles(cacheConfigDir, ".*\\.config");
            }
        }
        return true;
    }

    @Override
    public boolean isCacheEnabled(String name) {
        Object o = this.mPredefinedCacheMap.get(name);
        if (o == null) {
            return this.mDefaultCacheFactory == null ? false : this.mDefaultCacheFactory.isCacheEnabled(name);
        }
        return !NOT_ENABLED_CACHE.equals(o);
    }

    @Override
    public void shutdown() {
        if (this.mNamedCacheFactoryArray == null) {
            return;
        }
        for (int i = 0; i < this.mNamedCacheFactoryArray.length; ++i) {
            INamedCacheFactory o = this.mNamedCacheFactoryArray[i];
            if (!(o instanceof ILifeCycle)) continue;
            ILifeCycle s = (ILifeCycle)((Object)o);
            s.shutdown();
        }
        if (this.mLoadedLifeCycleList != null) {
            for (ILifeCycle l : this.mLoadedLifeCycleList) {
                try {
                    l.shutdown();
                }
                catch (Throwable thr) {
                    this.mLogger.log(Level.WARNING, "Error when shuting down instance " + l, thr);
                }
            }
        }
    }

    @Override
    public void setNamedCache(String name, ICache cache) {
        Object o = this.mPredefinedCacheMap.get(name);
        if (o == null) {
            if (this.mDefaultCacheFactory != null) {
                this.mDefaultCacheFactory.setNamedCache(name, cache);
            }
        } else {
            if (NOT_ENABLED_CACHE.equals(o)) {
                return;
            }
            ((INamedCacheFactory)o).setNamedCache(name, cache);
        }
    }

    public String getCacheConfig() {
        return this.cacheConfig;
    }

    public void setCacheConfig(String cacheConfig) {
        this.cacheConfig = cacheConfig;
    }

    private void scanConfigFiles(File dir, String file_pattern) {
        CompositeLoader compositeLoader = CompositeLoader.createInstanceForOCM();
        FilePatternFilter filter = new FilePatternFilter(file_pattern);
        File[] cfg_files = dir.listFiles(filter);
        List<File> file_list = FileUtil.getSortedList(cfg_files);
        Logger console = Logger.getLogger(this.getClass().getCanonicalName());
        if (cfg_files.length > 0) {
            ListIterator<File> fit = file_list.listIterator(cfg_files.length);
            while (fit.hasPrevious()) {
                File file = fit.previous();
                String file_path = file.getAbsolutePath();
                this.mLogger.log("Loading configuration file " + file_path);
                try {
                    ILifeCycle c;
                    CompositeMap config_map = compositeLoader.loadByFullFilePath(file_path);
                    Object inst = this.mEngine.getOcManager().createObject(config_map);
                    if (inst == null) {
                        console.warning("Can't load initialize config file " + file_path);
                        continue;
                    }
                    if (!(inst instanceof ICacheProvider)) {
                        console.warning("config file " + file_path + " is not an ICacheProvider object.");
                        continue;
                    }
                    if (inst instanceof IGlobalInstance) {
                        this.mEngine.getObjectRegistry().registerInstance(inst);
                    }
                    if (inst instanceof IContextListener) {
                        this.mEngine.addContextListener((IContextListener)inst);
                    }
                    if (inst instanceof ILifeCycle && !this.mLoadedLifeCycleList.contains(c = (ILifeCycle)inst) && c.startup()) {
                        this.mLoadedLifeCycleList.add(c);
                    }
                    this.cacheProviderSet.add((ICacheProvider)inst);
                }
                catch (Throwable thr) {
                    console.warning("Can't load initialize config file " + file_path);
                    this.mEngine.logException("Error when loading configuration file " + file_path, thr);
                }
            }
        }
    }

    public void onInitialize() throws Exception {
        for (ICacheProvider cacheApp : this.cacheProviderSet) {
            cacheApp.onInitialize();
        }
    }
}

