/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.touch;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewComponentPackage;
import aurora.presentation.ViewContext;
import aurora.presentation.markup.HtmlPageContext;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;
import uncertain.event.Configuration;
import uncertain.proc.IFeature;

public class Component
implements IFeature {
    CompositeMap view_config;
    protected static final String CLASS = "cls";

    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        this.addStyleSheet(session, context, "base/touch-all-min.css");
    }

    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return "";
    }

    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        CompositeMap view = context.getView();
        Map map = context.getMap();
        String clazz = this.getDefaultClass(session, context);
        String className = view.getString("classname", "");
        if (!"".equals(className)) {
            clazz = clazz + " " + className;
        }
        map.put(CLASS, clazz);
    }

    protected void addJavaScript(BuildSession session, ViewContext context, String javascript) {
        if (!session.includeResource(javascript)) {
            HtmlPageContext page = HtmlPageContext.getInstance(context);
            String js = session.getResourceUrl(javascript);
            page.addScript(js);
        }
    }

    protected void addStyleSheet(BuildSession session, ViewContext context, String style) {
        if (!session.includeResource(style)) {
            HtmlPageContext page = HtmlPageContext.getInstance(context);
            ViewComponentPackage pkg = session.getPresentationManager().getPackage(this.view_config);
            String styleSheet = session.getResourceUrl(pkg, style);
            page.addStyleSheet(styleSheet);
        }
    }

    @Override
    public int attachTo(CompositeMap config_data, Configuration config) {
        this.view_config = config_data;
        return 0;
    }
}

