/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.config.MenuBarConfig;
import java.io.IOException;
import java.util.Map;
import uncertain.composite.CompositeMap;

public class MenuBar
extends Component {
    public static final String CONFIG_CONTEXT = "context";
    private static final String DEFAULT_CLASS = "item-menu-bar";

    @Override
    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return DEFAULT_CLASS;
    }

    @Override
    protected int getDefaultWidth() {
        return -1;
    }

    @Override
    protected int getDefaultHeight() {
        return -1;
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        this.addStyleSheet(session, context, "menu/Menu.css");
        this.addJavaScript(session, context, "menu/Menu.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        CompositeMap view = context.getView();
        MenuBarConfig mbc = MenuBarConfig.getInstance(view);
        map.put("bindtarget", view.getString("bindtarget"));
        this.addConfig("displayfield", mbc.getDisplayField());
        if (null != mbc.getRenderer()) {
            this.addConfig("renderer", mbc.getRenderer());
        }
        this.addConfig("idfield", mbc.getIdField());
        this.addConfig("parentfield", mbc.getParentField());
        this.addConfig("rootid", new Integer(mbc.getRootId()));
        if (session.getContextPath() != null) {
            this.addConfig(CONFIG_CONTEXT, session.getContextPath());
        }
        if (null != mbc.getFocus()) {
            this.addConfig("focus", mbc.getFocus());
        }
        this.addConfig("iconfield", mbc.getIconField());
        this.addConfig("sequencefield", mbc.getSequenceField());
        if (null != mbc.getMenuType()) {
            this.addConfig("menutype", mbc.getMenuType());
        }
        if (null != mbc.getURLTarget()) {
            this.addConfig("urltarget", mbc.getURLTarget());
        }
        this.addConfig("urlfield", mbc.getURLField());
        map.put("config", this.getConfigString());
    }
}

