/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.component.std.Box;
import java.io.Writer;
import java.util.Map;
import uncertain.composite.CompositeMap;

public class Form
extends Box {
    private static final String DEFAULT_HEAD_CLASS = "form_head";
    private static final String DEFAULT_BODY_CLASS = "form_body";

    @Override
    protected void buildHead(BuildSession session, CompositeMap model, CompositeMap view, int rows, int columns) throws Exception {
        Writer out = session.getWriter();
        String title = view.getString("title", "");
        if (!"".equals(title = session.getLocalizedPrompt(title))) {
            out.write("<thead><tr><th class='form_head' colspan=" + columns * 2 + ">");
            out.write(title);
            out.write("</th></tr></thead>");
        }
    }

    @Override
    protected void afterBuildTop(BuildSession session, CompositeMap model, CompositeMap view) throws Exception {
        Writer out = session.getWriter();
        out.write("<tbody class='form_body'>");
        String showmargin = view.getString("showmargin", "true");
        boolean showBorder = view.getBoolean("showborder", false);
        if ("true".equals(showmargin) && !showBorder) {
            out.write("<tr height='5'><td></td></tr>");
        }
        super.afterBuildTop(session, model, view);
    }

    @Override
    protected void buildTop(BuildSession session, CompositeMap model, CompositeMap view, Map map, int rows, int columns, String id) throws Exception {
        Writer out = session.getWriter();
        String cls = view.getString("classname", "");
        String style = view.getString("style", "");
        int cellspacing = view.getInt("cellspacing", 0);
        int cellpadding = view.getInt("cellpadding", 0);
        int width = this.getComponentWidth(model, view, map);
        int height = this.getComponentHeight(model, view, map);
        boolean showBorder = view.getBoolean("showborder", false);
        String className = "layout-table layout-form";
        String title = view.getString("title", "");
        if (!"".equals(title)) {
            className = className + " layout-title";
        }
        className = className + " " + cls;
        if (showBorder) {
            cellspacing = 1;
            className = className + " layout-border";
            style = style + " border:none;";
        }
        out.write("<table border=0 class='" + className + "' id='" + id + "'");
        if (width != 0) {
            out.write(" width=" + width);
        }
        if (height != 0) {
            out.write(" height=" + height);
        }
        if (!"".equals(style)) {
            out.write(" style='" + style + "'");
        }
        out.write(" cellpadding=" + cellpadding + " cellspacing=" + cellspacing + ">");
        this.buildHead(session, model, view, rows, columns);
        this.afterBuildTop(session, model, view);
    }

    @Override
    protected void buildFoot(BuildSession session, CompositeMap model, CompositeMap view) throws Exception {
        super.afterBuildTop(session, model, view);
        Writer out = session.getWriter();
        String showmargin = view.getString("showmargin", "true");
        boolean showBorder = view.getBoolean("showborder", false);
        if ("true".equals(showmargin) && !showBorder) {
            out.write("<tr height='5'><td></td></tr>");
        }
    }
}

