/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.features;

import aurora.bm.BusinessModel;
import aurora.bm.Field;
import aurora.bm.IModelFactory;
import aurora.bm.Relation;
import aurora.database.profile.IDatabaseFactory;
import java.io.IOException;
import uncertain.composite.CompositeMap;
import uncertain.core.ConfigurationError;
import uncertain.logging.ILogger;

public class MultiLanguageDisplay {
    static final String KEY_ML_MODEL = "model";
    static final String KEY_ML_SEQUENCE = "sequence";
    static final String KEY_ML_REF_TABLE = "ref_table";
    static final String KEY_ML_REF_FIELD = "ref_field";
    static final String KEY_ML_DESCRIPTION = "description";
    static final String KEY_ML_PK_ID = "pk_id";
    String mlModelString = null;
    String refTable = null;
    String refField = null;
    String mlDescription = null;
    String pkId = null;
    String sequence = null;
    BusinessModel mlModel = null;
    String mlTable = null;
    CompositeMap dbProperties = null;
    ILogger mLogger = null;
    boolean hasMlFields = false;

    public MultiLanguageDisplay(IModelFactory modelFactory, IDatabaseFactory databaseFactory) throws IOException {
        this.dbProperties = databaseFactory.getProperties();
        if (this.dbProperties == null) {
            throw new ConfigurationError("Database Properties undifined");
        }
        CompositeMap mlProperties = this.dbProperties.getChild("multi-language-storage");
        if (mlProperties == null) {
            throw new ConfigurationError("multi-language-storage Properties undifined");
        }
        this.refTable = mlProperties.getString(KEY_ML_REF_TABLE);
        if (this.refTable == null) {
            throw new ConfigurationError("multi-language-storage ref_table undifined");
        }
        this.refField = mlProperties.getString(KEY_ML_REF_FIELD);
        if (this.refField == null) {
            throw new ConfigurationError("multi-language-storage ref_field undifined");
        }
        this.mlDescription = mlProperties.getString(KEY_ML_DESCRIPTION);
        if (this.mlDescription == null) {
            throw new ConfigurationError("multi-language-storage description undifined");
        }
        this.pkId = mlProperties.getString(KEY_ML_PK_ID);
        if (this.pkId == null) {
            throw new ConfigurationError("multi-language-storage pk_id undifined");
        }
        this.mlModelString = mlProperties.getString(KEY_ML_MODEL);
        if (this.mlModelString == null) {
            throw new ConfigurationError("multi-language-storage model undifined");
        }
        this.sequence = mlProperties.getString(KEY_ML_SEQUENCE);
        if (this.sequence == null) {
            throw new ConfigurationError("multi-language-storage sequence undifined");
        }
        this.mlModel = modelFactory.getModelForRead(this.mlModelString);
        this.mlTable = this.mlModel.getBaseTable();
    }

    public void onPrepareBusinessModel(BusinessModel model) {
        Field[] fields = model.getFields();
        boolean is_create = false;
        Field field = null;
        Field refield = null;
        String alias = model.getAlias();
        String fieldName = null;
        String prompt = null;
        String multiLanguageDescField = null;
        int l = fields.length;
        for (int i = 0; i < l; ++i) {
            field = fields[i];
            if (field.isReferenceField()) {
                CompositeMap cmap = (CompositeMap)field.getReferredField().getObjectContext().clone();
                cmap.copy(field.getObjectContext());
                refield = Field.getInstance(cmap);
                Relation relation = model.getRelation(field.getRelationName());
                alias = relation.getReferenceAlias();
                if (alias == null) {
                    alias = field.getRelationName();
                }
                fieldName = field.getSourceField();
            } else {
                refield = field;
                fieldName = refield.getName();
            }
            if (refield.getMultiLanguage()) {
                this.hasMlFields = true;
                prompt = refield.getPrompt();
                multiLanguageDescField = refield.getMultiLanguageDescField();
                for (int j = 0; j < l; ++j) {
                    Field f = fields[j];
                    if (!f.getName().equalsIgnoreCase(multiLanguageDescField) || f.isExpression()) continue;
                    f.setExpression(this.createQuerySql(fieldName, alias));
                    is_create = true;
                    break;
                }
                if (!is_create) {
                    Field f = Field.createField(multiLanguageDescField);
                    f.setPrompt(prompt);
                    f.setForInsert(false);
                    f.setForUpdate(false);
                    f.setExpression(this.createQuerySql(fieldName, alias));
                    model.addField(f);
                }
            }
            is_create = false;
        }
        model.makeReady();
    }

    String createQuerySql(String fieldName, String alias) {
        StringBuffer sql = new StringBuffer();
        sql.append("(select ");
        sql.append(this.mlDescription);
        sql.append(" from ");
        sql.append(this.mlTable);
        sql.append(" where " + this.pkId + "=" + alias + "." + fieldName + "" + " and Language=${" + this.dbProperties.getString("language_path") + "})");
        return sql.toString();
    }
}

