/*
 * Decompiled with CFR 0.152.
 */
package aurora.database;

import uncertain.composite.CompositeMap;
import uncertain.util.QuickTagParser;
import uncertain.util.TagParseHandle;

public class DynamicSqlParseHandle
implements TagParseHandle {
    boolean mContainsDynamicSql = false;
    CompositeMap mParameter;

    public DynamicSqlParseHandle(CompositeMap param) {
        this.mParameter = param;
    }

    @Override
    public String ProcessTag(int index, String tag) {
        Object obj;
        if (tag.length() == 0) {
            return "";
        }
        String str = null;
        str = tag.charAt(0) == ':' ? ((obj = this.mParameter.getObject(tag = tag.substring(1))) == null ? "" : obj.toString()) : "${" + tag + "}";
        if (str.indexOf("${:") >= 0) {
            this.mContainsDynamicSql = true;
        }
        return str;
    }

    @Override
    public int ProcessCharacter(int index, char ch) {
        return ch;
    }

    public boolean containsDynamicSql() {
        return this.mContainsDynamicSql;
    }

    public static String processSql(String sql, CompositeMap param) {
        DynamicSqlParseHandle handle = new DynamicSqlParseHandle(param);
        QuickTagParser parser = new QuickTagParser();
        String result = parser.parse(sql, (TagParseHandle)handle);
        if (handle.containsDynamicSql()) {
            result = DynamicSqlParseHandle.processSql(result, param);
        }
        return result;
    }
}

