/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.msg;

import aurora.application.features.msg.IConsumer;
import aurora.application.features.msg.IMessageDispatcher;
import aurora.application.features.msg.IMessageHandler;
import aurora.application.features.msg.IMessageStub;
import aurora.application.features.msg.MessageDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import uncertain.core.ILifeCycle;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;

public class AuroraClientInstance
extends AbstractLocatableObject
implements ILifeCycle,
IMessageStub {
    public static final String PLUGIN = "aurora.application.features.msg";
    private IMessageHandler[] mMessageHandlers;
    private IConsumer[] consumers;
    private String url;
    private IObjectRegistry registry;
    private Map<String, IMessageHandler> handlersMap = new HashMap<String, IMessageHandler>();
    private IMessageDispatcher messageDispatcher;
    private Map<String, IConsumer> consumerMap;
    private boolean started = false;
    private Logger logger;

    public AuroraClientInstance(IObjectRegistry registry) {
        this.registry = registry;
        this.messageDispatcher = new MessageDispatcher(registry);
    }

    @Override
    public boolean startup() {
        if (this.started) {
            return true;
        }
        this.logger = Logger.getLogger(PLUGIN);
        if (this.url == null) {
            BuiltinExceptionFactory.createOneAttributeMissing(this, "url");
        }
        new Thread(){

            @Override
            public void run() {
                if (AuroraClientInstance.this.consumers != null) {
                    for (int i = 0; i < AuroraClientInstance.this.consumers.length; ++i) {
                        try {
                            AuroraClientInstance.this.consumers[i].init(AuroraClientInstance.this);
                            continue;
                        }
                        catch (Exception e) {
                            AuroraClientInstance.this.logger.log(Level.SEVERE, "init jms consumers failed!", e);
                        }
                    }
                }
            }
        }.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    AuroraClientInstance.this.onShutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.registry.registerInstance(IMessageStub.class, this);
        this.started = true;
        return true;
    }

    public void onShutdown() throws Exception {
        if (this.consumers != null) {
            for (int i = 0; i < this.consumers.length; ++i) {
                this.consumers[i].onShutdown();
            }
        }
    }

    @Override
    public IMessageHandler getMessageHandler(String name) {
        return this.handlersMap.get(name);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public IMessageHandler[] getMessageHandlers() {
        return this.mMessageHandlers;
    }

    public void setMessageHandlers(IMessageHandler[] messageHandlers) {
        this.mMessageHandlers = messageHandlers;
        for (int i = 0; i < messageHandlers.length; ++i) {
            this.handlersMap.put(messageHandlers[i].getName(), messageHandlers[i]);
        }
    }

    public IConsumer[] getConsumers() {
        return this.consumers;
    }

    public void setConsumers(IConsumer[] consumers) {
        this.consumers = consumers;
        if (consumers != null) {
            this.consumerMap = new HashMap<String, IConsumer>();
            if (consumers != null) {
                for (int i = 0; i < consumers.length; ++i) {
                    this.consumerMap.put(consumers[i].getTopic(), consumers[i]);
                }
            }
        }
    }

    @Override
    public IConsumer getConsumer(String topic) {
        return this.consumerMap.get(topic);
    }

    @Override
    public void shutdown() {
        try {
            this.onShutdown();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "shutdown aurora message instance failed!", e);
        }
    }

    @Override
    public IMessageDispatcher getDispatcher() {
        return this.messageDispatcher;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }
}

