/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.action;

import aurora.application.util.LanguageUtil;
import aurora.service.ServiceContext;
import aurora.service.validation.ErrorMessage;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class CheckDispatch
extends AbstractEntry {
    String name;
    String field;
    String value;
    String dispatchUrl;
    String message;
    IObjectRegistry registry;

    public CheckDispatch(IObjectRegistry r) {
        this.registry = r;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap context = runner.getContext();
        ServiceContext sc = ServiceContext.createServiceContext(context);
        String fieldvalue = (String)context.getObject(this.getField());
        String checkvalue = this.getValue();
        if (fieldvalue != null && fieldvalue.equals(checkvalue)) {
            context.putBoolean("success", false);
            String url = TextParser.parse(this.getDispatchUrl(), context);
            context.put("dispatch_url", url);
            String msg = this.message == null ? checkvalue : this.message;
            msg = LanguageUtil.getTranslatedMessage(this.registry, msg, context);
            ErrorMessage em = new ErrorMessage(checkvalue, msg, null);
            sc.setError(em.getObjectContext());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDispatchUrl() {
        return this.dispatchUrl;
    }

    public void setDispatchUrl(String dispatchUrl) {
        this.dispatchUrl = dispatchUrl;
    }
}

