/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.spnego;

import aurora.plugin.spnego.SpnegoConfig;
import aurora.plugin.spnego.SpnegoHttpServletRequest;
import aurora.plugin.spnego.SpnegoHttpServletResponse;
import aurora.plugin.spnego.SpnegoPrincipal;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.ietf.jgss.GSSException;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.ProcedureRunner;

public class SpnegoLogin
extends AbstractEntry {
    SpnegoConfig config;
    IProcedureManager procedureManager;
    IObjectRegistry mObjectRegistry;

    public SpnegoLogin(SpnegoConfig config, IProcedureManager procedureManager, IObjectRegistry registry) {
        this.config = config;
        this.procedureManager = procedureManager;
        this.mObjectRegistry = registry;
    }

    public void run(ProcedureRunner runner) throws Exception {
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.spnego", (IObjectRegistry)this.mObjectRegistry);
        ServiceContext context = ServiceContext.createServiceContext((CompositeMap)runner.getContext());
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context.getObjectContext());
        Object httpRequest = svc.getRequest();
        mLogger.info("user_id:" + httpRequest.getSession().getAttribute("user_id"));
        if (httpRequest.getSession().getAttribute("user_id") == null) {
            SpnegoPrincipal principal;
            String serviceName = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length() + 1);
            context.getParameter().putString((Object)"service_name", serviceName);
            mLogger.info("excute procedure " + this.config.getProcedure());
            this.doLogin(runner);
            Object result = svc.getContextMap().getObject(this.config.getLoginchekpath());
            if (result == null) {
                mLogger.log(Level.SEVERE, this.config.getLoginchekpath() + " is null");
                return;
            }
            List list = ((CompositeMap)result).getChilds();
            mLogger.info("context:" + svc.getContextMap().toXML());
            if (list != null) {
                mLogger.info(serviceName + " is not login required");
                return;
            }
            SpnegoHttpServletResponse spnegoResponse = new SpnegoHttpServletResponse(svc.getResponse());
            try {
                principal = this.config.getSpnegoAuthenticator().authenticate((HttpServletRequest)httpRequest, spnegoResponse);
            }
            catch (GSSException gsse) {
                throw new Exception(gsse);
            }
            if (spnegoResponse.isStatusSet()) {
                runner.stop();
                return;
            }
            if (null == principal) {
                spnegoResponse.setStatus(500, true);
                runner.stop();
                return;
            }
            httpRequest = new SpnegoHttpServletRequest((HttpServletRequest)httpRequest, principal);
            String username = httpRequest.getRemoteUser();
            context.getParameter().put((Object)"user_name", (Object)username.toUpperCase());
            mLogger.info("username:" + username);
            context.getParameter().put((Object)"status_code", (Object)"Y");
            this.doLogin(runner);
            mLogger.info("doLogin context:" + svc.getContextMap().toXML());
        }
    }

    void doLogin(ProcedureRunner runner) throws Exception {
        String procedure = this.config.getProcedure();
        runner.call(this.procedureManager.loadProcedure(procedure));
    }
}

