/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.ntlm;

import aurora.plugin.ntlm.NtlmAuthenticator;
import aurora.plugin.ntlm.NtlmConfig;
import aurora.plugin.ntlm.NtlmException;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jcifs.smb.NtlmPasswordAuthentication;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.AbstractEntry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.ProcedureRunner;

public class NtlmLogin
extends AbstractEntry {
    IProcedureManager procedureManager;
    IObjectRegistry mObjectRegistry;
    NtlmConfig ntlmConfig;
    ILogger mLogger;

    public NtlmLogin(NtlmConfig config, IProcedureManager procedureManager, IObjectRegistry registry) {
        this.ntlmConfig = config;
        this.procedureManager = procedureManager;
        this.mObjectRegistry = registry;
    }

    public void run(ProcedureRunner runner) throws Exception {
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.ntlm", (IObjectRegistry)this.mObjectRegistry);
        CompositeMap context = runner.getContext();
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)context);
        HttpServletRequest httpRequest = svc.getRequest();
        String msg = httpRequest.getHeader("Authorization");
        if (httpRequest.getSession().getAttribute("user_id") == null) {
            NtlmPasswordAuthentication ntlm;
            if (context.getObject("/cookie/@JSID/@value") != null && !"Y".equals(context.getObject("/cookie/@IS_NTLM/@value"))) {
                return;
            }
            mLogger.info("httpRequest Authorization:{" + msg + "}");
            if (msg == null || !msg.startsWith("NTLM")) {
                context.putObject("/request/@service_name", (Object)svc.getName(), true);
                runner.call(this.procedureManager.loadProcedure(this.ntlmConfig.getProcedure()));
                Object result = context.getObject(this.ntlmConfig.getReturnPath());
                if (result == null) {
                    mLogger.log(Level.SEVERE, this.ntlmConfig.getReturnPath() + " is null");
                    return;
                }
                if (((CompositeMap)result).getChilds() != null) {
                    mLogger.info(svc.getName() + " is not login required");
                    return;
                }
            }
            if ((ntlm = this.authenticate(runner)) == null) {
                return;
            }
            String locale = httpRequest.getLocale().toString();
            String username = ntlm.getUsername().toUpperCase();
            mLogger.info("username:" + username);
            context.putObject("/spnego/@user_name", (Object)username, true);
            context.putObject("/spnego/@status_code", (Object)"Y", true);
            context.putObject("/spnego/@locale", (Object)locale, true);
            runner.call(this.procedureManager.loadProcedure(this.ntlmConfig.getProcedure()));
            mLogger.info("excute procedure " + this.ntlmConfig.getProcedure());
        } else if ("POST".equals(httpRequest.getMethod().toUpperCase()) && msg != null && msg.startsWith("NTLM")) {
            this.authenticate(runner);
        }
    }

    NtlmPasswordAuthentication authenticate(ProcedureRunner runner) throws IOException {
        NtlmPasswordAuthentication ntlm;
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.ntlm", (IObjectRegistry)this.mObjectRegistry);
        HttpServiceInstance svc = (HttpServiceInstance)ServiceInstance.getInstance((CompositeMap)runner.getContext());
        HttpServletRequest httpRequest = svc.getRequest();
        HttpServletResponse httpResponse = svc.getResponse();
        try {
            ntlm = new NtlmAuthenticator(this.ntlmConfig).authenticate(httpRequest, httpResponse);
            if (ntlm == null) {
                mLogger.log(Level.INFO, "runner is stop;ServiceName:" + svc.getName());
                runner.stop();
                return null;
            }
        }
        catch (NtlmException ntlmException) {
            mLogger.log(Level.WARNING, "NTLM authenticate fail;ServiceName:" + svc.getName(), (Throwable)ntlmException);
            if (this.ntlmConfig.getEnableBasic()) {
                String realm = "Ntlm Auth failure,Please use the basic authentication";
                httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
                httpResponse.setStatus(401);
                httpResponse.setContentLength(0);
                httpResponse.flushBuffer();
                runner.stop();
            }
            return null;
        }
        catch (Exception e) {
            mLogger.log(Level.WARNING, "NTLM authenticate fail;ServiceName:" + svc.getName(), (Throwable)e);
            if (this.ntlmConfig.getEnableBasic()) {
                String realm = e.getMessage();
                httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"" + realm + "\"");
                httpResponse.setStatus(401);
                httpResponse.setContentLength(0);
                httpResponse.flushBuffer();
                runner.stop();
            }
            return null;
        }
        mLogger.log(Level.INFO, "NTLM authenticate domain:" + ntlm.getDomain() + ";Username:" + ntlm.getUsername() + ";name:" + ntlm.getName() + ";IP:" + httpRequest.getRemoteHost() + "ServiceName:" + svc.getName());
        return ntlm;
    }
}

