/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.ntlm;

import aurora.plugin.ntlm.DomainInstance;
import aurora.plugin.ntlm.NtlmConfig;
import aurora.plugin.ntlm.NtlmException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.http.NtlmSsp;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type3Message;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbSession;
import jcifs.util.Base64;
import uncertain.composite.CompositeMap;

public class NtlmAuthenticator {
    private String defaultDomain;
    private String domainController;
    private String realm;
    private boolean offerBasic;
    NtlmConfig ntlmConfig;

    public NtlmAuthenticator(NtlmConfig ntlmConfig) {
        this.ntlmConfig = ntlmConfig;
        this.offerBasic = ntlmConfig.getEnableBasic();
    }

    public NtlmPasswordAuthentication authenticate(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        NtlmPasswordAuthentication ntlm = null;
        String msg = req.getHeader("Authorization");
        if (msg != null && msg.startsWith("NTLM ")) {
            Type1Message type1 = null;
            Type3Message type3 = null;
            byte[] token = Base64.decode((String)msg.substring(5));
            if (token[8] == 1) {
                type1 = new Type1Message(token);
                this.defaultDomain = type1.getSuppliedDomain();
            } else if (token[8] == 3) {
                type3 = new Type3Message(token);
                this.defaultDomain = type3.getDomain();
            }
            DomainInstance domainInstance = this.defaultDomain == null ? this.ntlmConfig.getDefaultDomainInstance() : this.ntlmConfig.getDomainInstance(this.defaultDomain.toUpperCase());
            if (domainInstance == null) {
                throw new NtlmException("DomainInstance is null;defaultDomain:" + this.defaultDomain + ";type1:" + type1 + ";type3:" + type3);
            }
            this.domainController = domainInstance.getDomainController();
            Config.setProperty((String)"jcifs.smb.client.domain", (String)domainInstance.getDomain());
            Config.setProperty((String)"jcifs.smb.client.username", (String)domainInstance.getUserName());
            Config.setProperty((String)"jcifs.smb.client.password", (String)domainInstance.getPassword());
            UniAddress dc = UniAddress.getByName((String)this.domainController, (boolean)true);
            byte[] challenge = SmbSession.getChallenge((UniAddress)dc);
            ntlm = NtlmSsp.authenticate((HttpServletRequest)req, (HttpServletResponse)resp, (byte[])challenge);
            if (ntlm == null) {
                return null;
            }
            SmbSession.logon((UniAddress)dc, (NtlmPasswordAuthentication)ntlm);
            return ntlm;
        }
        if (msg != null && msg.startsWith("Basic ") && this.offerBasic) {
            String auth = new String(Base64.decode((String)msg.substring(6)), "US-ASCII");
            int index = auth.indexOf(58);
            String user = index != -1 ? auth.substring(0, index) : auth;
            String password = index != -1 ? auth.substring(index + 1) : "";
            index = user.indexOf(92);
            if (index == -1) {
                index = user.indexOf(47);
            }
            user = index != -1 ? user.substring(index + 1) : user;
            CompositeMap domianMap = this.ntlmConfig.getDomainInstances();
            Set keySet = domianMap.keySet();
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                DomainInstance instance = (DomainInstance)domianMap.get(iterator.next());
                Config.setProperty((String)"jcifs.smb.client.domain", (String)instance.getDomain());
                Config.setProperty((String)"jcifs.smb.client.username", (String)instance.getUserName());
                Config.setProperty((String)"jcifs.smb.client.password", (String)instance.getPassword());
                this.defaultDomain = instance.getDomain();
                this.domainController = instance.getDomainController();
                String domain = index != -1 ? user.substring(0, index) : this.defaultDomain;
                ntlm = new NtlmPasswordAuthentication(domain, user, password);
                UniAddress dc = UniAddress.getByName((String)this.domainController, (boolean)true);
                try {
                    SmbSession.logon((UniAddress)dc, (NtlmPasswordAuthentication)ntlm);
                    return ntlm;
                }
                catch (SmbAuthException e) {
                    e.printStackTrace();
                }
            }
        }
        resp.setHeader("WWW-Authenticate", "NTLM");
        if (this.offerBasic) {
            this.realm = "Basic Authenticate Logon failure: unknown user name or bad password";
            resp.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
        }
        resp.setStatus(401);
        resp.setContentLength(0);
        resp.flushBuffer();
        return null;
    }
}

