/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.httpclient;

import aurora.bm.BusinessModel;
import aurora.database.service.BusinessModelService;
import aurora.database.service.DatabaseServiceFactory;
import aurora.service.http.WebContextInit;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import uncertain.composite.CompositeMap;
import uncertain.core.UncertainEngine;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;

public class HttpClient
extends HttpServlet {
    private static final long serialVersionUID = -3144250964634670506L;
    String KEY_ADDRESS = "address";
    String KEY_PROCEDURE = "procedure";
    String KEY_OUTPUT = "output";
    String procedure;
    String returnPath;
    String address;
    IProcedureManager mProcManager;
    ProcedureRunner mRunner;
    UncertainEngine mUncertainEngine;
    DatabaseServiceFactory svcFactory;

    protected void service(HttpServletRequest request, HttpServletResponse response) {
        boolean is_check = false;
        try {
            if (!this.mUncertainEngine.isRunning()) {
                StringBuffer msg = new StringBuffer("Application failed to initialize");
                Throwable thr = this.mUncertainEngine.getInitializeException();
                if (thr != null) {
                    msg.append(":").append(thr.getMessage());
                }
                response.sendError(500, msg.toString());
                return;
            }
            String param = this.getParam(request);
            if (this.procedure != null) {
                this.mProcManager = this.mUncertainEngine.getProcedureManager();
                Procedure proc = this.mProcManager.loadProcedure(this.procedure);
                CompositeMap context = new CompositeMap("context");
                HttpSession httpSession = request.getSession();
                Enumeration enume = httpSession.getAttributeNames();
                CompositeMap session = context.createChild("session");
                while (enume.hasMoreElements()) {
                    String key = (String)enume.nextElement();
                    session.put((Object)key, httpSession.getAttribute(key));
                }
                CompositeMap parameter = context.createChild("parameter");
                parameter.putString((Object)"param", param);
                this.mRunner = new ProcedureRunner();
                this.mRunner.setProcedure(proc);
                this.mRunner.setContext(context);
                this.mRunner.run();
                Object msg = context.getObject(this.returnPath);
                if (msg != null) {
                    response.sendError(500, msg.toString());
                } else {
                    is_check = true;
                }
                BusinessModel bm = (BusinessModel)context.get((Object)"BusinessModel");
                BusinessModelService service = this.svcFactory.getModelService(bm, context);
                service.getServiceContext().freeConnection();
            } else {
                is_check = true;
            }
            if (is_check) {
                this.writeResponse(response, this.address + "?" + param);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String getParam(HttpServletRequest request) {
        StringBuffer params = new StringBuffer();
        boolean isFirst = true;
        Enumeration enumn = request.getParameterNames();
        while (enumn.hasMoreElements()) {
            String paramName = (String)enumn.nextElement();
            String[] paramValues = request.getParameterValues(paramName);
            int length = paramValues.length;
            for (int i = 0; i < length; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    params.append("&");
                }
                params.append(paramName);
                params.append("=");
                params.append(paramValues[i].replace(' ', '+'));
            }
        }
        return params.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(HttpServletResponse httpResponse, String url) throws Exception {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        OutputStream os = null;
        InputStream is = null;
        try {
            HttpGet httpget = new HttpGet(url);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpget);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                int len;
                os = httpResponse.getOutputStream();
                is = entity.getContent();
                int Buffer_size = 51200;
                byte[] buf = new byte[Buffer_size];
                while ((len = is.read(buf)) > 0) {
                    os.write(buf, 0, len);
                }
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ignore) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception ignore) {}
            }
            httpclient.getConnectionManager().shutdown();
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.mUncertainEngine = (UncertainEngine)this.getServletContext().getAttribute(WebContextInit.KEY_UNCERTAIN_ENGINE);
        this.svcFactory = (DatabaseServiceFactory)this.mUncertainEngine.getObjectRegistry().getInstanceOfType(DatabaseServiceFactory.class);
        this.procedure = super.getInitParameter(this.KEY_PROCEDURE);
        this.returnPath = super.getInitParameter(this.KEY_OUTPUT);
        this.address = super.getInitParameter(this.KEY_ADDRESS);
    }
}

