/*
 * Decompiled with CFR 0.152.
 */
package uncertain.proc;

import uncertain.exception.BuiltinExceptionFactory;
import uncertain.ocm.OCManager;
import uncertain.proc.IExceptionHandle;
import uncertain.proc.Procedure;
import uncertain.proc.ProcedureRunner;

public class Catch
extends Procedure
implements IExceptionHandle {
    String _exception;
    String _destination;
    String _next_step;
    boolean handle_any_type = false;
    Class _exception_class;

    public Catch() {
    }

    public Catch(OCManager om) {
        super(om);
    }

    public String getDestination() {
        return this._destination;
    }

    public void setDestination(String _destination) {
        this._destination = _destination;
    }

    public String getNextStep() {
        return this._next_step;
    }

    public void setNextStep(String nextStep) {
        this._next_step = nextStep;
    }

    public void setException(String type) {
        this._exception = type;
        if ("*".equals(this._exception)) {
            this.handle_any_type = true;
            return;
        }
        try {
            this._exception_class = Class.forName(this._exception);
        }
        catch (ClassNotFoundException ex) {
            throw BuiltinExceptionFactory.createClassNotFoundException(this, type);
        }
    }

    public String getException() {
        return this._exception;
    }

    void locateRunner(ProcedureRunner runner) {
        if (this._next_step != null) {
            runner.locateTo(this._next_step);
            runner.mResumeAfterException = true;
        }
    }

    @Override
    public boolean handleException(ProcedureRunner runner, Throwable exception) {
        boolean match_exception = this.handle_any_type;
        if (!this.handle_any_type) {
            if (this._exception_class == null) {
                throw BuiltinExceptionFactory.createAttributeMissing(this, "exception");
            }
            match_exception = this._exception_class.isInstance(exception);
        }
        if (match_exception) {
            if (this._destination != null) {
                runner.getContext().putObject(this._destination, (Object)exception, true);
            }
            runner.run(this);
            Throwable thr = runner.getException();
            if (thr != exception) {
                return false;
            }
            this.locateRunner(runner);
            return true;
        }
        return false;
    }
}

