/*
 * Decompiled with CFR 0.152.
 */
package uncertain.datatype;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import uncertain.datatype.AbstractDataType;
import uncertain.datatype.ConvertionException;
import uncertain.datatype.DataType;

public class TimestampType
extends AbstractDataType
implements DataType {
    String mDateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    String mDateFormat2 = "yyyy-MM-dd";

    @Override
    public Object convert(Object value) throws ConvertionException {
        try {
            return this.convert(value, this.mDateTimeFormat);
        }
        catch (ConvertionException e) {
            return this.convert(value, this.mDateFormat2);
        }
    }

    @Override
    public Object convert(Object value, String fmt) throws ConvertionException {
        if (value instanceof String) {
            String str = (String)value;
            try {
                SimpleDateFormat format = new SimpleDateFormat(fmt);
                return new Timestamp(((Date)format.parseObject(str)).getTime());
            }
            catch (Exception ex) {
                throw new ConvertionException("Can't convert from string to Timestamp", ex);
            }
        }
        if (value instanceof Number) {
            return new Timestamp(((Number)value).longValue());
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        return null;
    }

    @Override
    public Class getJavaType() {
        return Timestamp.class;
    }

    @Override
    public Object getObject(CallableStatement stmt, int id) throws SQLException {
        return stmt.getTimestamp(id);
    }

    @Override
    public Object getObject(ResultSet rs, int id) throws SQLException {
        return rs.getTimestamp(id);
    }

    @Override
    public void setParameter(PreparedStatement stmt, int id, Object value) throws SQLException {
        if (value == null) {
            stmt.setNull(id, this.getSqlType());
        } else {
            stmt.setTimestamp(id, (Timestamp)value);
        }
    }

    @Override
    public int getSqlType() {
        return 93;
    }

    @Override
    public void registerParameter(CallableStatement stmt, int id) throws SQLException {
        stmt.registerOutParameter(id, 93);
    }
}

