/*
 * Decompiled with CFR 0.152.
 */
package uncertain.core;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import uncertain.composite.CompositeMap;
import uncertain.composite.DynamicObject;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.util.MapHandle;
import uncertain.util.QuickTagParser;
import uncertain.util.TagParseHandle;
import uncertain.util.resource.ILocatable;

public class DirectoryConfig
extends DynamicObject {
    public static final String KEY_PATH_CONFIG = "path-config";
    public static final String KEY_LOG_PATH = "logpath";
    public static final String KEY_CONFIG_PATH = "configpath";
    public static final String KEY_BASE_PATH = "basepath";

    public static DirectoryConfig createDirectoryConfig(CompositeMap dir_config) {
        DirectoryConfig dir = new DirectoryConfig();
        dir.initialize(dir_config);
        return dir;
    }

    public static DirectoryConfig createDirectoryConfig() {
        CompositeMap dir_config = new CompositeMap(KEY_PATH_CONFIG);
        return DirectoryConfig.createDirectoryConfig(dir_config);
    }

    public static void checkIsPathValid(ILocatable locatable, String path) {
        File file = new File(path);
        if (!file.exists() || !file.isDirectory()) {
            throw BuiltinExceptionFactory.createInvalidPathException(locatable, path);
        }
    }

    public String getLogDirectory() {
        return this.getString(KEY_LOG_PATH);
    }

    public void setLogDirectory(String dir) {
        this.putString(KEY_LOG_PATH, dir);
    }

    public String getBaseDirectory() {
        return this.getString(KEY_BASE_PATH);
    }

    public void setBaseDirectory(String base_dir) {
        this.putString(KEY_BASE_PATH, base_dir);
    }

    public String getConfigDirectory() {
        return this.getString(KEY_CONFIG_PATH);
    }

    public void setConfigDirectory(String config_dir) {
        this.putString(KEY_CONFIG_PATH, config_dir);
    }

    public String translateRealPath(String path_with_tag) {
        QuickTagParser parser = new QuickTagParser();
        MapHandle handle = new MapHandle(this.getObjectContext(), 2);
        return parser.parse(path_with_tag, (TagParseHandle)handle);
    }

    public void loadConfigProperties(File property_file) throws IOException {
        Properties props = new Properties();
        FileReader reader = new FileReader(property_file);
        props.load(reader);
        this.loadConfig(props);
        reader.close();
    }

    public void loadConfig(Map config_map) {
        for (Map.Entry entry : config_map.entrySet()) {
            if (entry.getKey() == null) continue;
            String key = entry.getKey().toString().toLowerCase();
            Object value = entry.getValue();
            this.object_context.put(key, value);
        }
    }

    public void validateConfig() {
        for (Map.Entry entry : this.object_context.entrySet()) {
            if (entry.getKey() == null) continue;
            Object value = entry.getValue();
            if (value == null) {
                throw BuiltinExceptionFactory.createInvalidPathException(this.object_context.asLocatable(), "(" + entry.getKey().toString() + "=null)");
            }
            String path = value.toString();
            File file = new File(path);
            if (file.exists() && file.isDirectory()) continue;
            throw BuiltinExceptionFactory.createInvalidPathException(this.object_context.asLocatable(), path);
        }
    }
}

