/*
 * Decompiled with CFR 0.152.
 */
package aurora.i18n;

import aurora.database.FetchDescriptor;
import aurora.database.service.BusinessModelService;
import aurora.database.service.IDatabaseServiceFactory;
import aurora.database.service.SqlServiceContext;
import aurora.i18n.CacheBasedLocalizedMessageProvider;
import aurora.i18n.ILocalizedMessageProvider;
import aurora.i18n.IMessageProvider;
import java.util.HashMap;
import java.util.List;
import uncertain.cache.ICache;
import uncertain.cache.INamedCacheFactory;
import uncertain.composite.CompositeMap;
import uncertain.core.IGlobalInstance;
import uncertain.exception.GeneralException;
import uncertain.ocm.AbstractLocatableObject;

public class CacheBasedMessageProvider
extends AbstractLocatableObject
implements IMessageProvider,
IGlobalInstance {
    private IDatabaseServiceFactory mFactory;
    private INamedCacheFactory mCacheFactory;
    private String langPath = "";
    private String defaultLang = "";
    private String languageColumn;
    private String keyColumn;
    private String valueColumn;
    private String bm;
    private String cacheName;
    private HashMap localMPMaps = new HashMap();
    private ICache cache;

    public CacheBasedMessageProvider(IDatabaseServiceFactory factory, INamedCacheFactory cacheFactory) {
        this.mFactory = factory;
        this.mCacheFactory = cacheFactory;
    }

    public void onInitialize() throws Exception {
        this.cache = this.mCacheFactory.getNamedCache(this.cacheName);
        if (this.cache == null) {
            throw new GeneralException("uncertain.cache.named_cache_not_found", new Object[]{this.cacheName}, this);
        }
        this.cacheMessage();
    }

    @Override
    public ILocalizedMessageProvider getLocalizedMessageProvider(String language_code) {
        return (ILocalizedMessageProvider)this.localMPMaps.get(language_code);
    }

    @Override
    public String getMessage(String language_code, String message_code) {
        return String.valueOf(this.cache.getValue(this.getFullCacheKey(message_code, language_code)));
    }

    @Override
    public String getMessage(String language_code, String message_code, Object[] params) {
        ILocalizedMessageProvider localMessageProvider = (ILocalizedMessageProvider)this.localMPMaps.get(language_code);
        if (localMessageProvider == null) {
            return message_code;
        }
        return localMessageProvider.getMessage(message_code, params);
    }

    private void cacheMessage() throws Exception {
        CompositeMap resultMap = this.queryBM(new CompositeMap());
        if (resultMap != null) {
            List list = resultMap.getChildsNotNull();
            for (CompositeMap message : list) {
                String language = message.getString(this.getLanguageColumn());
                ILocalizedMessageProvider localMessageProvider = (ILocalizedMessageProvider)this.localMPMaps.get(language);
                if (localMessageProvider == null) {
                    localMessageProvider = new CacheBasedLocalizedMessageProvider(language, this.cache);
                    this.localMPMaps.put(language, localMessageProvider);
                }
                String code = message.getString(this.getKeyColumn());
                String description = message.getString(this.getValueColumn());
                localMessageProvider.putMessage(code, description);
            }
        }
    }

    private String getFullCacheKey(String code, String langugage) {
        return code + "." + langugage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeMap queryBM(CompositeMap queryMap) throws Exception {
        SqlServiceContext sqlContext = this.mFactory.createContextWithConnection();
        try {
            CompositeMap resultMap;
            CompositeMap context = sqlContext.getObjectContext();
            if (context == null) {
                context = new CompositeMap();
            }
            BusinessModelService service = this.mFactory.getModelService(this.getBm(), context);
            CompositeMap compositeMap = resultMap = service.queryAsMap(queryMap, FetchDescriptor.fetchAll());
            return compositeMap;
        }
        finally {
            if (sqlContext != null) {
                sqlContext.freeConnection();
            }
        }
    }

    @Override
    public String getLangPath() {
        return this.langPath;
    }

    public void setLangPath(String langPath) {
        this.langPath = langPath;
    }

    @Override
    public String getDefaultLang() {
        return this.defaultLang;
    }

    public void setDefaultLang(String defaultLang) {
        this.defaultLang = defaultLang;
    }

    public String getLanguageColumn() {
        return this.languageColumn;
    }

    public void setLanguageColumn(String languageColumn) {
        this.languageColumn = languageColumn;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public void setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
    }

    public String getValueColumn() {
        return this.valueColumn;
    }

    public void setValueColumn(String valueColumn) {
        this.valueColumn = valueColumn;
    }

    public String getBm() {
        return this.bm;
    }

    public void setBm(String bm) {
        this.bm = bm;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }
}

