/*
 * Decompiled with CFR 0.152.
 */
package aurora.i18n;

import aurora.i18n.ILocalizedMessageProvider;
import java.util.Locale;
import uncertain.cache.ICache;
import uncertain.cache.MapBasedCache;

public class CacheBasedLocalizedMessageProvider
implements ILocalizedMessageProvider {
    private ICache cache;
    private String lang;

    public CacheBasedLocalizedMessageProvider(String lang, ICache cache) {
        this.cache = cache;
        this.lang = lang;
        if (lang == null) {
            this.lang = Locale.getDefault().getLanguage();
        }
        if (cache == null) {
            cache = new MapBasedCache();
        }
    }

    public CacheBasedLocalizedMessageProvider() {
        this.lang = Locale.getDefault().getLanguage();
        this.cache = new MapBasedCache();
    }

    @Override
    public String getMessage(String code) {
        return (String)this.cache.getValue(this.getKey(code));
    }

    @Override
    public String getMessage(String code, Object[] params) {
        return null;
    }

    @Override
    public void putMessage(String code, String description) {
        this.cache.setValue(this.getKey(code), description);
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getLang() {
        return this.lang;
    }

    public String getKey(String code) {
        return code + "." + this.lang;
    }
}

