/*
 * Decompiled with CFR 0.152.
 */
package aurora.datasource;

import aurora.datasource.DatabaseConnection;
import aurora.datasource.INamedDataSourceProvider;
import aurora.datasource.NamedDataSourceProvider;
import aurora.plugin.xapool.TransactionService;
import aurora.plugin.xapool.XADataSources;
import aurora.service.IServiceFactory;
import aurora.service.ServiceFactoryImpl;
import aurora.transaction.ITransactionService;
import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.DriverManagerDataSource;
import com.mchange.v2.c3p0.PooledDataSource;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.enhydra.jdbc.pool.StandardXAPoolDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import uncertain.core.IContainer;
import uncertain.core.ILifeCycle;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;
import uncertain.ocm.OCManager;
import uncertain.proc.IProcedureManager;

public class DataSourceConfig
implements ILifeCycle {
    DatabaseConnection[] mDatabaseConnections;
    boolean useTransactionManager = false;
    IObjectRegistry mObjectRegistry;
    ILogger mLogger;
    OCManager mOCManager;

    public DataSourceConfig(IObjectRegistry reg, OCManager ocManager) {
        this.mLogger = LoggingContext.getLogger("aurora.datasource", reg);
        this.mObjectRegistry = reg;
        this.mOCManager = ocManager;
    }

    private ServiceFactoryImpl createServiceFactory(ITransactionService ts) {
        IProcedureManager pr = (IProcedureManager)this.mObjectRegistry.getInstanceOfType(IProcedureManager.class);
        IContainer container = (IContainer)this.mObjectRegistry.getInstanceOfType(IContainer.class);
        ServiceFactoryImpl sf = new ServiceFactoryImpl(container, ts, pr);
        return sf;
    }

    @Override
    public boolean startup() {
        try {
            int length = this.mDatabaseConnections.length;
            DataSource ds = null;
            TransactionService ts = null;
            NamedDataSourceProvider dsProvider = new NamedDataSourceProvider();
            DatabaseConnection dbConfig = null;
            if (this.useTransactionManager) {
                TransactionManager tm = null;
                ts = new TransactionService(true);
                tm = ts.getTransactionManager();
                for (int i = 0; i < length; ++i) {
                    dbConfig = this.mDatabaseConnections[i];
                    ds = XADataSources.unpooledXADataSource(dbConfig.getUrl(), dbConfig.getUserName(), dbConfig.getPassword(), dbConfig.getDriverClass(), tm);
                    if (dbConfig.getPool()) {
                        ds = XADataSources.pooledXADataSource((XADataSource)((Object)ds));
                        this.mOCManager.populateObject(dbConfig.config, (StandardXAPoolDataSource)ds);
                    }
                    this.registryDataSource(ds, dbConfig, dsProvider);
                }
            } else {
                if (length != 1) {
                    this.mLogger.log(Level.SEVERE, "TransactionManager is disabled,please use only one datasource");
                    throw new RuntimeException("TransactionManager is disabled,please use only one datasource");
                }
                ts = new TransactionService(false);
                dbConfig = this.mDatabaseConnections[0];
                ds = DataSources.unpooledDataSource((String)dbConfig.getUrl(), (String)dbConfig.getUserName(), (String)dbConfig.getPassword());
                ((DriverManagerDataSource)ds).setDriverClass(dbConfig.getDriverClass());
                if (dbConfig.getPool() && dbConfig.config != null) {
                    ds = DataSources.pooledDataSource((DataSource)ds, (Map)dbConfig.config);
                }
                this.registryDataSource(ds, dbConfig, dsProvider);
            }
            this.mObjectRegistry.registerInstance(INamedDataSourceProvider.class, dsProvider);
            this.mObjectRegistry.registerInstance(ITransactionService.class, ts);
            ServiceFactoryImpl sf = this.createServiceFactory(ts);
            this.mObjectRegistry.registerInstance(IServiceFactory.class, sf);
            this.mObjectRegistry.registerInstance(DataSourceConfig.class, this);
            return true;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void registryDataSource(DataSource ds, DatabaseConnection dbConfig, INamedDataSourceProvider dsProvider) throws RuntimeException {
        String dataSourceName = dbConfig.getName();
        if (ds == null) {
            this.mLogger.log(Level.SEVERE, "dataSource not initialized");
            throw new RuntimeException(dataSourceName + " dataSource not initialized");
        }
        if (dataSourceName == null) {
            this.mLogger.log(Level.CONFIG, "Setting up dataSource url:{0},user:{1}", new Object[]{dbConfig.getUrl(), dbConfig.getUserName()});
            this.mObjectRegistry.registerInstance(DataSource.class, ds);
        } else {
            ((NamedDataSourceProvider)dsProvider).putDataSource(dbConfig.getName(), ds);
            this.mLogger.log(Level.CONFIG, "Setting up dataSource url:{0},user:{1},name:{2}", new Object[]{dbConfig.getUrl(), dbConfig.getUserName(), dbConfig.getName()});
        }
    }

    public boolean getUseTransactionManager() {
        return this.useTransactionManager;
    }

    public void setUseTransactionManager(boolean useTransactionManager) {
        this.useTransactionManager = useTransactionManager;
    }

    public DatabaseConnection[] getDatabaseConnections() {
        return this.mDatabaseConnections;
    }

    public void setDatabaseConnections(DatabaseConnection[] DataBases) {
        this.mDatabaseConnections = DataBases;
    }

    @Override
    public void shutdown() {
        DataSource ds = (DataSource)this.mObjectRegistry.getInstanceOfType(DataSource.class);
        INamedDataSourceProvider dsProvider = (INamedDataSourceProvider)this.mObjectRegistry.getInstanceOfType(INamedDataSourceProvider.class);
        this.cleanDataSource(ds);
        if (dsProvider != null) {
            Map dsMap = dsProvider.getAllDataSources();
            Iterator iterator = dsMap.keySet().iterator();
            while (iterator.hasNext()) {
                ds = (DataSource)dsMap.get(iterator.next());
                this.cleanDataSource(ds);
            }
        }
    }

    void cleanDataSource(DataSource ds) {
        if (ds != null) {
            if (ds instanceof PooledDataSource) {
                try {
                    ((PooledDataSource)ds).close();
                }
                catch (SQLException e) {
                    e.printStackTrace(System.err);
                }
            }
            if (ds instanceof StandardXADataSource) {
                ((StandardXADataSource)ds).shutdown(true);
            }
            if (ds instanceof StandardXAPoolDataSource) {
                ((StandardXAPoolDataSource)ds).stopPool();
            }
        }
    }
}

