/*
 * Decompiled with CFR 0.152.
 */
package aurora.database.sql;

import aurora.database.sql.BaseField;
import aurora.database.sql.BaseTable;
import aurora.database.sql.ISqlStatement;
import aurora.database.sql.SelectField;
import aurora.database.sql.SelectStatement;

public class SelectSource
extends BaseTable {
    public static final String SELECT_FROM = "SELECT_FROM";
    SelectStatement subQuery;
    boolean isSubQuery;

    public SelectSource(String tableName) {
        super(SELECT_FROM);
        this.setTableName(tableName);
    }

    public SelectSource(SelectStatement subQuery) {
        super(SELECT_FROM);
        this.setSubQuery(subQuery);
    }

    @Override
    public void setTableName(String tableName) {
        super.setTableName(tableName);
        this.isSubQuery = false;
        if (this.subQuery != null) {
            this.subQuery.setParent(null);
            this.subQuery = null;
        }
    }

    @Override
    public String getTableName() {
        if (this.isSubQuery()) {
            return this.subQuery.toString();
        }
        return super.getTableName();
    }

    public void setSubQuery(SelectStatement subQuery) {
        this.isSubQuery = true;
        this.tableName = null;
        this.subQuery = subQuery;
        this.subQuery.setParent(this);
    }

    public SelectStatement getSubQuery() {
        return this.subQuery;
    }

    public boolean isSubQuery() {
        return this.isSubQuery;
    }

    @Override
    protected BaseField createFieldInstance(String name, String alias) {
        SelectField field = new SelectField((ISqlStatement)this, name);
        if (alias != null) {
            field.setAlias(alias);
        }
        return field;
    }

    @Override
    public BaseField getField(String name) {
        if (this.isSubQuery) {
            return this.subQuery.getField(name);
        }
        return super.getField(name);
    }

    public SelectField getSelectField(String name) {
        return (SelectField)this.getField(name);
    }

    public SelectField createSelectField(String name, String alias) {
        return (SelectField)this.createField(name, alias);
    }

    public SelectField createSelectField(String name) {
        return (SelectField)this.createField(name, null);
    }
}

