/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.features.msg;

import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageHandler;
import aurora.service.IServiceFactory;
import aurora.service.ServiceInvoker;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.proc.IProcedureManager;
import uncertain.proc.Procedure;

public class DefaultMessageHandler
extends AbstractLocatableObject
implements IMessageHandler {
    private IObjectRegistry registry;
    private String name;
    private String procedure;
    private IProcedureManager procedureManager;
    private IServiceFactory serviceFactory;

    public DefaultMessageHandler(IObjectRegistry registry) {
        this.registry = registry;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(IMessage message) {
        ILogger logger = LoggingContext.getLogger(this.getClass().getPackage().getName(), this.registry);
        logger.log(Level.INFO, "accepted a new message\uff01");
        if (this.procedureManager == null) {
            this.procedureManager = (IProcedureManager)this.registry.getInstanceOfType(IProcedureManager.class);
            if (this.procedureManager == null) {
                throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IProcedureManager.class, this.getClass().getName());
            }
            this.serviceFactory = (IServiceFactory)this.registry.getInstanceOfType(IServiceFactory.class);
            if (this.serviceFactory == null) {
                throw BuiltinExceptionFactory.createInstanceNotFoundException(this, IServiceFactory.class, this.getClass().getName());
            }
        }
        if (this.procedure == null) {
            throw BuiltinExceptionFactory.createAttributeMissing(this, "procedure");
        }
        if (message == null) {
            logger.log(Level.WARNING, "message is null");
            return;
        }
        CompositeMap context = new CompositeMap();
        try {
            CompositeMap properties = message.getProperties();
            if (properties != null && !properties.isEmpty()) {
                Set entrySet = properties.entrySet();
                for (Map.Entry entry : entrySet) {
                    context.putObject("/parameter/message/@" + entry.getKey(), entry.getValue(), true);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error when handle message properties ", e);
        }
        try {
            logger.log(Level.CONFIG, "receive message text:{0}", new Object[]{message.getText()});
            logger.log(Level.CONFIG, "load procedure:{0}", new Object[]{this.procedure});
            Procedure proc = null;
            try {
                proc = this.procedureManager.loadProcedure(this.procedure);
            }
            catch (Exception ex) {
                throw BuiltinExceptionFactory.createResourceLoadException(this, this.procedure, ex);
            }
            String name = "MSG." + this.procedure;
            ServiceInvoker.invokeProcedureWithTransaction(name, proc, this.serviceFactory, context);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error when invoking procedure " + this.procedure, ex);
        }
        finally {
            context.clear();
        }
    }

    public String getProcedure() {
        return this.procedure;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }
}

