/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.action;

import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import aurora.service.validation.ImageValidationException;
import javax.servlet.http.HttpSession;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;
import uncertain.proc.AbstractEntry;
import uncertain.proc.ProcedureRunner;

public class ImageValidate
extends AbstractEntry {
    private String code;
    private String errorMessage;

    @Override
    public void run(ProcedureRunner runner) throws Exception {
        CompositeMap mContext = runner.getContext();
        HttpServiceInstance mService = (HttpServiceInstance)ServiceInstance.getInstance(mContext);
        HttpSession session = mService.getRequest().getSession();
        if (session != null) {
            String imageCode = (String)session.getAttribute("validate_code");
            String checkCode = TextParser.parse(this.getCode(), mContext);
            if (imageCode != null && !imageCode.equalsIgnoreCase(checkCode)) {
                throw new ImageValidationException(this.getErrorMessage());
            }
            session.setAttribute("validate_code", null);
        }
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getErrorMessage() {
        return this.errorMessage == null ? "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165" : this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

