/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap;

import aurora.plugin.sap.FieldMapping;
import com.sap.mw.jco.JCO;
import java.util.HashMap;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.core.ConfigurationError;
import uncertain.logging.ILogger;

public class Table {
    public static final String IMPORT = "import";
    public static final String EXPORT = "export";
    public String Name;
    public String Target;
    public String Type = "export";
    public boolean fetchAll = false;
    public String Source_field;
    ILogger logger;
    FieldMapping[] field_mappings;
    HashMap name_map;

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public boolean getFetchAll() {
        return this.fetchAll;
    }

    public void setFetchAll(boolean fetchAll) {
        this.fetchAll = fetchAll;
    }

    public void setFieldMappings(FieldMapping[] m) {
        this.field_mappings = m;
        this.name_map = new HashMap();
        for (int i = 0; i < m.length; ++i) {
            if (m[i].Name == null) {
                throw new ConfigurationError("Must set 'name' for <field-mapping>");
            }
            this.name_map.put(m[i].Name.toLowerCase(), m[i]);
        }
    }

    public FieldMapping[] getFieldMappings() {
        return this.field_mappings;
    }

    public boolean isImport() {
        return IMPORT.equalsIgnoreCase(this.Type);
    }

    public JCO.Table getJCOTable(JCO.ParameterList list) {
        try {
            JCO.Table table = list.getTable(this.Name);
            if (table == null) {
                throw new IllegalArgumentException("Table '" + this.Name + "' doesn't exist");
            }
            return table;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Can't get table '" + this.Name + "':" + t.getMessage());
        }
    }

    public void fillJCOTable(JCO.Table table, CompositeMap context) {
        CompositeMap map = (CompositeMap)context.getObject(this.Source_field);
        int line = 0;
        if (map.getChildIterator() != null) {
            List records = map.getChilds();
            table.appendRows(records.size());
            this.logger.info("Appending " + records.size() + " rows to ABAP table " + this.Name);
            for (CompositeMap record : records) {
                this.logger.info("================ end line " + line + "=====================");
                for (int i = 0; i < this.field_mappings.length; ++i) {
                    FieldMapping mapping = this.field_mappings[i];
                    Object value = record.getObject(mapping.Source_field);
                    if (value == null) {
                        value = mapping.Value;
                    }
                    this.logger.info(mapping.Name + " -> " + value);
                    table.setValue(value, mapping.Name);
                }
                table.nextRow();
                ++line;
            }
            this.logger.info("\r\nTable transfered");
        }
    }

    public CompositeMap fillCompositeMap(JCO.Table records, CompositeMap result) {
        FieldMapping mapping = null;
        records.firstRow();
        if (this.field_mappings != null && this.field_mappings.length > 0 && !this.fetchAll) {
            for (int n = 0; n < records.getNumRows(); ++n) {
                CompositeMap item = new CompositeMap((int)((double)records.getFieldCount() * 1.5));
                item.setName("record");
                for (int i = 0; i < this.field_mappings.length; ++i) {
                    mapping = this.field_mappings[i];
                    String returnField = mapping.Return_field;
                    if (returnField == null) {
                        throw new ConfigurationError("Must set 'return_field' for <field-mapping>");
                    }
                    item.putObject(returnField, records.getValue(mapping.Name));
                }
                result.addChild(item);
                records.nextRow();
            }
            return result;
        }
        for (int n = 0; n < records.getNumRows(); ++n) {
            CompositeMap item = new CompositeMap((int)((double)records.getFieldCount() * 1.5));
            item.setName("record");
            for (int col = 0; col < records.getNumColumns(); ++col) {
                String fieldName = records.getField(col).getName();
                if (this.name_map != null) {
                    mapping = (FieldMapping)this.name_map.get(fieldName.toLowerCase());
                }
                if (mapping != null) {
                    String returnField = mapping.Return_field;
                    if (returnField == null) {
                        throw new ConfigurationError("Must set 'return_field' for <field-mapping>");
                    }
                    item.putObject(returnField, records.getValue(col));
                    continue;
                }
                item.put((Object)fieldName, records.getValue(col));
            }
            result.addChild(item);
            records.nextRow();
        }
        return result;
    }
}

