/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.jms;

import aurora.application.features.msg.IMessage;
import aurora.application.features.msg.IMessageListener;
import aurora.application.features.msg.IMessageStub;
import aurora.application.features.msg.INoticerConsumer;
import aurora.plugin.jms.JMSMessage;
import aurora.plugin.jms.JMSStub;
import aurora.plugin.jms.JMSUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.GeneralException;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.AbstractLocatableObject;
import uncertain.ocm.IObjectRegistry;
import uncertain.util.resource.ILocatable;

public class DefaultNoticeConsumer
extends AbstractLocatableObject
implements INoticerConsumer,
MessageListener,
ExceptionListener {
    private String topic;
    private String client;
    private Session session;
    private Connection connection;
    private MessageConsumer messageConsumer;
    private Map<String, List<IMessageListener>> messageListeners = new HashMap<String, List<IMessageListener>>();
    private ILogger logger;
    private IObjectRegistry registry;

    public DefaultNoticeConsumer(IObjectRegistry registry) {
        this.registry = registry;
    }

    public void init(IMessageStub stub) throws Exception {
        if (!(stub instanceof JMSStub)) {
            throw new IllegalArgumentException("The IMessageStub is not IJMSMessageStub!");
        }
        JMSStub jmsStub = (JMSStub)stub;
        if (this.topic == null) {
            throw BuiltinExceptionFactory.createAttributeMissing((ILocatable)this, (String)"topic");
        }
        this.logger = LoggingContext.getLogger((String)"aurora.plugin.jms", (IObjectRegistry)this.registry);
        this.logger.log(Level.CONFIG, "init Consumer");
        this.connection = jmsStub.createConnection();
        this.connection.setExceptionListener((ExceptionListener)this);
        if (this.client == null) {
            this.client = this.getAutoClient(this.topic);
        }
        this.connection.setClientID(this.client);
        this.session = this.connection.createSession(false, 1);
        Topic jmsTopic = this.session.createTopic(this.topic);
        this.logger.log(Level.CONFIG, "create Topic:{0}", new Object[]{this.topic});
        this.messageConsumer = this.session.createDurableSubscriber(jmsTopic, this.topic);
        this.messageConsumer.setMessageListener((MessageListener)this);
        this.connection.start();
        this.logger.log(Level.CONFIG, "start Consumer successfull!");
    }

    public void onShutdown() {
        JMSUtil.freeMessageConsumer(this.messageConsumer);
        JMSUtil.freeJMSSession(this.session);
        JMSUtil.freeJMSConnection(this.connection);
    }

    public void onMessage(Message message) {
        if (!(message instanceof TextMessage)) {
            ILocatable locatable = null;
            throw new GeneralException("aurora.plugin.amq.message_type_error", new Object[]{TextMessage.class.getName(), message.getClass().getCanonicalName()}, locatable);
        }
        String messageText = null;
        try {
            messageText = ((TextMessage)message).getText();
        }
        catch (JMSException e) {
            throw new GeneralException("aurora.plugin.amq.jmsexception_error", new Object[]{e.getMessage()}, (Throwable)e);
        }
        List<IMessageListener> listeners = this.messageListeners.get(messageText);
        if (listeners != null) {
            for (IMessageListener l : listeners) {
                try {
                    l.notice((IMessage)new JMSMessage((TextMessage)message));
                }
                catch (Exception e) {
                    this.logger.log(Level.SEVERE, "Listener:" + l.toString() + " occur exception.", (Throwable)e);
                    throw new RuntimeException("Listener:" + l.toString() + " occur exception.", e);
                }
            }
        }
    }

    public void onMessage(IMessage msg) throws Exception {
        throw new IllegalArgumentException("This method will never be called is this class!");
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getAutoClient(String topic) {
        return Calendar.getInstance().getTimeInMillis() + (topic != null ? topic : "");
    }

    public void onException(JMSException paramJMSException) {
        paramJMSException.printStackTrace();
        this.logger.log(Level.SEVERE, "JMSException:", (Throwable)paramJMSException);
    }

    public void addListener(String message, IMessageListener listener) {
        List<IMessageListener> listeners = this.messageListeners.get(message);
        if (listeners == null) {
            listeners = new LinkedList<IMessageListener>();
            this.messageListeners.put(message, listeners);
        }
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public void removeListener(String message, IMessageListener listener) {
        List<IMessageListener> listeners = this.messageListeners.get(message);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
    }
}

