/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.export;

import aurora.i18n.ILocalizedMessageProvider;
import aurora.i18n.IMessageProvider;
import aurora.plugin.poi.ExcelExportImpl;
import aurora.service.ServiceContext;
import aurora.service.ServiceInstance;
import aurora.service.http.HttpServiceInstance;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import uncertain.composite.CompositeMap;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IObjectRegistry;

public class ModelExport {
    public final String KEY_COLUMN_CONFIG = "_column_config_";
    public final String KEY_FILE_NAME = "_file_name_";
    public final String KEY_CHARSET = "GBK";
    public final String KEY_PROMPT = "prompt";
    public final String KEY_DATA_INDEX = "name";
    public final String KEY_COLUMN = "column";
    public final String KEY_WIDTH = "width";
    public final String KEY_GENERATE_STATE = "_generate_state";
    public final String KEY_FORMAT = "_format";
    IObjectRegistry mObjectRegistry;

    public ModelExport(IObjectRegistry registry) {
        this.mObjectRegistry = registry;
    }

    public int preInvokeService(ServiceContext context) throws Exception {
        if (!context.getParameter().getBoolean((Object)"_generate_state", false)) {
            return 0;
        }
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.export", (IObjectRegistry)this.mObjectRegistry);
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)context.getObjectContext());
        CompositeMap config = svc.getServiceConfigData().getChild("init-procedure");
        if (config == null) {
            mLogger.log(Level.SEVERE, "init-procedure tag must be defined");
            throw new ServletException("init-procedure tag must be defined");
        }
        Iterator iterator = config.getChildIterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                CompositeMap modelQueryMap = (CompositeMap)iterator.next();
                if (!"model-query".equals(modelQueryMap.getName())) continue;
                modelQueryMap.putBoolean((Object)"fetchall", true);
            }
        }
        return 0;
    }

    public int preCreateSuccessResponse(ServiceContext context) throws Exception {
        CompositeMap parameter = context.getParameter();
        if (!parameter.getBoolean((Object)"_generate_state", false)) {
            return 0;
        }
        IMessageProvider msgProvider = (IMessageProvider)this.mObjectRegistry.getInstanceOfType(IMessageProvider.class);
        String langString = context.getSession().getString((Object)"lang", "ZHS");
        ILocalizedMessageProvider localMsgProvider = msgProvider.getLocalizedMessageProvider(langString);
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)context.getObjectContext());
        HttpServletResponse response = ((HttpServiceInstance)svc).getResponse();
        String fileName = parameter.getString((Object)"_file_name_", "excel");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("GBK");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + ".xls\"");
        ExcelExportImpl excelFactory = new ExcelExportImpl(localMsgProvider);
        excelFactory.createExcel(this.getExportData(context), this.getColumnConfig(context), (OutputStream)response.getOutputStream());
        return 2;
    }

    CompositeMap getExportData(ServiceContext context) throws ServletException {
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.export", (IObjectRegistry)this.mObjectRegistry);
        ServiceInstance svc = ServiceInstance.getInstance((CompositeMap)context.getObjectContext());
        String return_path = (String)svc.getServiceConfigData().getObject("service-output/@output");
        if (return_path == null) {
            mLogger.log(Level.SEVERE, "_column_config_ must be defined");
            throw new ServletException("_column_config_ must be defined");
        }
        CompositeMap exportData = (CompositeMap)context.getModel().getObject(return_path);
        return exportData;
    }

    CompositeMap getColumnConfig(ServiceContext context) throws ServletException {
        ILogger mLogger = LoggingContext.getLogger((String)"aurora.plugin.export", (IObjectRegistry)this.mObjectRegistry);
        CompositeMap column_config = (CompositeMap)context.getParameter().getObject("_column_config_/column");
        if (column_config == null) {
            mLogger.log(Level.SEVERE, "service-output tag and output attibute must be defined");
            throw new ServletException("service-output tag and output attibute must be defined");
        }
        return column_config;
    }
}

