/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.application.config.ScreenConfig;
import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.IDGenerator;
import aurora.presentation.component.std.JSONFunction;
import aurora.presentation.component.std.config.EventConfig;
import aurora.presentation.markup.HtmlPageContext;
import aurora.service.IService;
import aurora.service.ServiceInstance;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;
import uncertain.composite.TextParser;

public class Component {
    protected static final String CONFIG = "config";
    protected static final String WRAP_CSS = "wrapClass";
    protected static final String BINDING = "binding";
    protected static final String PROPERTITY_MARGIN_WIDTH = "marginwidth";
    protected static final String PROPERTITY_MARGIN_HEIGHT = "marginheight";
    protected String id;
    private JSONObject listeners = new JSONObject();
    private StringBuffer bsb = new StringBuffer();
    private JSONObject config = new JSONObject();

    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        this.addStyleSheet(session, context, "base/Aurora-all-min.css");
        this.addJavaScript(session, context, "base/ext-core-min.js");
        this.addJavaScript(session, context, "base/Aurora-all-min.js");
        this.addJavaScript(session, context, "locale/aurora-lang-" + session.getLanguage() + ".js");
    }

    protected String getDefaultClass(BuildSession session, ViewContext context) {
        return "";
    }

    protected int getDefaultWidth() {
        return 150;
    }

    protected int getDefaultHeight() {
        return 20;
    }

    protected Integer getComponentWidth(CompositeMap model, CompositeMap view, Map map) {
        String widthStr;
        String wstr;
        CompositeMap root = view.getRoot();
        CompositeMap vwc = null;
        String vws = null;
        Integer vw = null;
        if (root != null) {
            vws = (String)root.getObject("/parameter/@_vw");
            if (vws == null) {
                vwc = (CompositeMap)root.getObject("/cookie/@vw");
                if (vwc != null) {
                    vw = vwc.getInt("value");
                }
            } else {
                vw = Integer.valueOf(vws);
            }
        }
        Integer width = "".equals(wstr = TextParser.parse(widthStr = view.getString("width", "" + this.getDefaultWidth()), model)) ? new Integer(this.getDefaultWidth()) : Integer.valueOf(wstr);
        map.put("oldwidth", width);
        Integer marginWidth = view.getInt(PROPERTITY_MARGIN_WIDTH);
        if (marginWidth != null && vw != null) {
            width = new Integer(vw - marginWidth > width ? vw - marginWidth : width);
            this.addConfig(PROPERTITY_MARGIN_WIDTH, marginWidth);
        }
        return width;
    }

    protected Integer getComponentHeight(CompositeMap model, CompositeMap view, Map map) {
        String heightStr;
        String hstr;
        CompositeMap root = view.getRoot();
        CompositeMap vhc = null;
        String vhs = null;
        Integer vh = null;
        if (root != null) {
            if (vhs == null) {
                vhc = (CompositeMap)root.getObject("/cookie/@vh");
                if (vhc != null) {
                    vh = vhc.getInt("value");
                }
            } else {
                vh = Integer.valueOf(vhs);
            }
        }
        Integer height = "".equals(hstr = TextParser.parse(heightStr = view.getString("height", "" + this.getDefaultHeight()), model)) ? new Integer(this.getDefaultHeight()) : Integer.valueOf(hstr);
        Integer marginHeight = view.getInt(PROPERTITY_MARGIN_HEIGHT);
        if (marginHeight != null && vh != null) {
            height = new Integer(vh - marginHeight > height ? vh - marginHeight : height);
            this.addConfig(PROPERTITY_MARGIN_HEIGHT, marginHeight);
        }
        return height;
    }

    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        List list;
        String name;
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        Map map = context.getMap();
        Boolean isCust = view.getBoolean("iscust");
        this.id = view.getString("id", "");
        if ("".equals(this.id)) {
            this.id = IDGenerator.getInstance().generate();
        } else if (isCust == null) {
            isCust = new Boolean(true);
        }
        this.addConfig("iscust", isCust);
        this.id = TextParser.parse(this.id, model);
        map.put("id", this.id);
        this.addConfig("id", this.id);
        String clazz = this.getDefaultClass(session, context);
        String className = view.getString("classname", "");
        if (!"".equals(className)) {
            clazz = clazz + " " + className;
        }
        map.put(WRAP_CSS, clazz);
        Integer width = this.getComponentWidth(model, view, map);
        map.put("width", width);
        this.addConfig("width", width);
        Integer height = this.getComponentHeight(model, view, map);
        if (height != 0) {
            map.put("height", height);
            this.addConfig("height", height);
        }
        if ("".equals(name = view.getString("name", ""))) {
            name = IDGenerator.getInstance().generate();
        }
        map.put("name", name);
        String style = view.getString("style", "");
        map.put("style", style);
        String value = view.getString("value", "");
        map.put("value", value);
        CompositeMap events = view.getChild("events");
        if (events != null && (list = events.getChilds()) != null) {
            for (CompositeMap event : list) {
                EventConfig eventConfig = EventConfig.getInstance(event);
                String eventName = eventConfig.getEventName();
                String handler = eventConfig.getHandler();
                if (!"".equals(eventName) && !"".equals(handler)) {
                    handler = TextParser.parse(handler, model);
                }
                this.addEvent(this.id, eventName, handler);
            }
        }
        this.addConfig("listeners", this.listeners);
        String bindTarget = view.getString("bindtarget", "");
        if (!bindTarget.equals("")) {
            bindTarget = TextParser.parse(bindTarget, model);
            map.put("bindtarget", bindTarget);
            this.bsb.append("$('" + this.id + "').bind('" + bindTarget + "','" + name + "');\n");
            map.put(BINDING, this.bsb.toString());
        }
    }

    protected void addJavaScript(BuildSession session, ViewContext context, String javascript) {
        if (!session.includeResource(javascript)) {
            HtmlPageContext page = HtmlPageContext.getInstance(context);
            String js = session.getResourceUrl(javascript);
            page.addScript(js);
        }
    }

    protected void addStyleSheet(BuildSession session, ViewContext context, String style) {
        if (!session.includeResource(style)) {
            HtmlPageContext page = HtmlPageContext.getInstance(context);
            String styleSheet = session.getResourceUrl(style);
            page.addStyleSheet(styleSheet);
        }
    }

    protected void addEvent(String id, String eventName, String handler) {
        try {
            this.listeners.put(eventName, new JSONFunction(handler));
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    protected void addConfig(String key, Object value) {
        try {
            this.config.put(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getConfigString() {
        return this.config.toString();
    }

    protected JSONObject getConfig() {
        return this.config;
    }

    protected String getFieldPrompt(BuildSession session, CompositeMap field, String dataset) {
        String label = field.getString("prompt", "");
        if ("".equals(label)) {
            CompositeMap fieldcm;
            String name = field.getString("name", "");
            CompositeMap ds = this.getDataSet(session, dataset);
            if (ds != null && (fieldcm = ds.getChild("fields")) != null) {
                List fields = fieldcm.getChilds();
                for (CompositeMap fieldMap : fields) {
                    String fn = fieldMap.getString("name", "");
                    if (!name.equals(fn)) continue;
                    label = fieldMap.getString("prompt", "");
                    break;
                }
            }
        }
        return label;
    }

    private CompositeMap getDataSet(BuildSession session, String dataSetName) {
        CompositeMap dataset = null;
        ServiceInstance svc = (ServiceInstance)session.getInstanceOfType(IService.class);
        ScreenConfig screen = ScreenConfig.createScreenConfig(svc.getServiceConfigData());
        CompositeMap datasets = screen.getDataSetsConfig();
        if (datasets != null) {
            List list = datasets.getChilds();
            for (CompositeMap ds : list) {
                String dsname = ds.getString("id", "");
                if (!dataSetName.equals(dsname)) continue;
                dataset = ds;
                break;
            }
        }
        return dataset;
    }
}

