/*
 * Decompiled with CFR 0.152.
 */
package aurora.presentation.component.std;

import aurora.presentation.BuildSession;
import aurora.presentation.ViewContext;
import aurora.presentation.component.std.Component;
import aurora.presentation.component.std.JSONFunction;
import aurora.presentation.component.std.config.EventConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uncertain.composite.CompositeMap;

public class Chart
extends Component {
    public static String INPUT_TYPE = "inputtype";
    public static String DEFAULT_INPUT_TYPE = "input";
    private static final String PROPERTITY_SERIES_NAME = "seriesName";
    private static final String PROPERTITY_THEME = "chartTheme";
    private static final String PROPERTITY_CHART_TYPE = "type";
    private static final String PROPERTITY_CHART_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_CHART_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_CHART_BORDERRADIUS = "borderRadius";
    private static final String PROPERTITY_CHART_CLASS_NAME = "className";
    private static final String PROPERTITY_CHART_IGNORE_HIDDEN_SERIES = "ignoreHiddenSeries";
    private static final String PROPERTITY_CHART_INVERTED = "inverted";
    private static final String PROPERTITY_CHART_MARGIN_TOP = "marginTop";
    private static final String PROPERTITY_CHART_MARGIN_RIGHT = "marginRight";
    private static final String PROPERTITY_CHART_MARGIN_LEFT = "marginLeft";
    private static final String PROPERTITY_CHART_MARGIN_BOTTOM = "marginBottom";
    private static final String PROPERTITY_CHART_PLOT_BACKGROUND_COLOR = "plotBackgroundColor";
    private static final String PROPERTITY_CHART_PLOT_BACKGROUND_IMAGE = "plotBackgroundImage";
    private static final String PROPERTITY_CHART_PLOT_BORDER_COLOR = "plotBorderColor";
    private static final String PROPERTITY_CHART_PLOT_BORDER_WIDTH = "plotBorderWidth";
    private static final String PROPERTITY_CHART_PLOT_SHADOW = "plotShadow";
    private static final String PROPERTITY_CHART_REFLOW = "reflow";
    private static final String PROPERTITY_CHART_SHADOW = "shadow";
    private static final String PROPERTITY_CHART_SHOW_AXES = "showAxes";
    private static final String PROPERTITY_CHART_SPACING_TOP = "spacingTop";
    private static final String PROPERTITY_CHART_SPACING_RIGHT = "spacingRight";
    private static final String PROPERTITY_CHART_SPACING_BOTTOM = "spacingBottom";
    private static final String PROPERTITY_CHART_SPACING_LEFT = "spacingLeft";
    private static final String PROPERTITY_CHART_STYLE = "chartStyle";
    private static final String PROPERTITY_CHART_ZOOM_TYP = "zoomType";
    private static final String PROPERTITY_LABELS = "labels";
    private static final String PROPERTITY_LABELS_STYLE = "style";
    private static final String PROPERTITY_LABELS_LABEL_HTML = "html";
    private static final String PROPERTITY_LABELS_LABEL_STYLE = "style";
    private static final String PROPERTITY_TITLE_TEXT = "text";
    private static final String PROPERTITY_TITLE_X = "x";
    private static final String PROPERTITY_TITLE_Y = "y";
    private static final String PROPERTITY_TITLE_ALIGN = "align";
    private static final String PROPERTITY_TITLE_MARGIN = "margin";
    private static final String PROPERTITY_TITLE_FLOATING = "floating";
    private static final String PROPERTITY_TITLE_STYLE = "style";
    private static final String PROPERTITY_TITLE_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_SUBTITLE_TEXT = "text";
    private static final String PROPERTITY_SUBTITLE_X = "x";
    private static final String PROPERTITY_SUBTITLE_Y = "y";
    private static final String PROPERTITY_SUBTITLE_ALIGN = "align";
    private static final String PROPERTITY_SUBTITLE_FLOATING = "floating";
    private static final String PROPERTITY_SUBTITLE_STYLE = "style";
    private static final String PROPERTITY_SUBTITLE_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_LEGEND_ALIGN = "align";
    private static final String PROPERTITY_LEGEND_BACKGROUNDCOLOR = "backgroundColor";
    private static final String PROPERTITY_LEGEND_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_LEGEND_BORDERRADIUS = "borderRadius";
    private static final String PROPERTITY_LEGEND_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_LEGEND_ENABLED = "enabled";
    private static final String PROPERTITY_LEGEND_FLOATING = "floating";
    private static final String PROPERTITY_LEGEND_ITEMSTYLE = "itemStyle";
    private static final String PROPERTITY_LEGEND_LAYOUT = "layout";
    private static final String PROPERTITY_LEGEND_LABELFORMATTER = "labelFormatter";
    private static final String PROPERTITY_LEGEND_MARGIN = "margin";
    private static final String PROPERTITY_LEGEND_REVERSED = "reversed";
    private static final String PROPERTITY_LEGEND_SHADOW = "shadow";
    private static final String PROPERTITY_LEGEND_STYLE = "style";
    private static final String PROPERTITY_LEGEND_SYMBOLPADDING = "symbolPadding";
    private static final String PROPERTITY_LEGEND_SYMBOLWIDTH = "symbolWidth";
    private static final String PROPERTITY_LEGEND_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_LEGEND_WIDTH = "width";
    private static final String PROPERTITY_LEGEND_X = "x";
    private static final String PROPERTITY_LEGEND_Y = "y";
    private static final String PROPERTITY_TOOLTIP_BACKGROUNDCOLOR = "backgroundColor";
    private static final String PROPERTITY_TOOLTIP_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_TOOLTIP_BORDERRADIUS = "borderRadius";
    private static final String PROPERTITY_TOOLTIP_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_TOOLTIP_ENABLED = "enabled";
    private static final String PROPERTITY_TOOLTIP_FORMATTER = "formatter";
    private static final String PROPERTITY_TOOLTIP_SHADOW = "shadow";
    private static final String PROPERTITY_TOOLTIP_SHARED = "shared";
    private static final String PROPERTITY_TOOLTIP_SNAP = "snap";
    private static final String PROPERTITY_TOOLTIP_STYLE = "style";
    private static final String PROPERTITY_AXIS_X = "xAxis";
    private static final String PROPERTITY_AXIS_Y = "yAxis";
    private static final String PROPERTITY_AXIS_ALLOWDECIMALS = "allowDecimals";
    private static final String PROPERTITY_AXIS_ALTERNATEGRIDCOLOR = "alternateGridColor";
    private static final String PROPERTITY_AXIS_CAGEGORIES = "categories";
    private static final String PROPERTITY_AXIS_GRIDLINECOLOR = "gridLineColor";
    private static final String PROPERTITY_AXIS_GRIDLINEDASHSTYLE = "gridLineDashStyle";
    private static final String PROPERTITY_AXIS_GRIDLINEWIDTH = "gridLineWidth";
    private static final String PROPERTITY_AXIS_ID = "id";
    private static final String PROPERTITY_AXIS_LINECOLOR = "lineColor";
    private static final String PROPERTITY_AXIS_LINEWIDTH = "lineWidth";
    private static final String PROPERTITY_AXIS_LINKTO = "linkedTo";
    private static final String PROPERTITY_AXIS_MAX = "max";
    private static final String PROPERTITY_AXIS_MAXPADDING = "maxPadding";
    private static final String PROPERTITY_AXIS_MAXZOOM = "maxZoom";
    private static final String PROPERTITY_AXIS_MIN = "min";
    private static final String PROPERTITY_AXIS_MINPADDING = "minPadding";
    private static final String PROPERTITY_AXIS_OFFSET = "offset";
    private static final String PROPERTITY_AXIS_OPPOSITE = "opposite";
    private static final String PROPERTITY_AXIS_NAME = "name";
    private static final String PROPERTITY_AXIS_PLOTBANDS = "plotBands";
    private static final String PROPERTITY_AXIS_PLOTBANDS_COLOR = "color";
    private static final String PROPERTITY_AXIS_PLOTBANDS_FROM = "from";
    private static final String PROPERTITY_AXIS_PLOTBANDS_ID = "id";
    private static final String PROPERTITY_AXIS_PLOTBANDS_TO = "to";
    private static final String PROPERTITY_AXIS_PLOTBANDS_ZINDEX = "zIndex";
    private static final String PROPERTITY_AXIS_PLOT_LABEL = "label";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_ALIGN = "align";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_TEXT = "text";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_VERTICALALIGN = "verticalAlign";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_RATATION = "rotation";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_STYLE = "style";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_TEXTALIGN = "textAlign";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_X = "x";
    private static final String PROPERTITY_AXIS_PLOT_LABEL_Y = "y";
    private static final String PROPERTITY_AXIS_PLOTLINES = "plotLines";
    private static final String PROPERTITY_AXIS_PLOTLINES_COLOR = "color";
    private static final String PROPERTITY_AXIS_PLOTLINES_ID = "id";
    private static final String PROPERTITY_AXIS_PLOTLINES_VALUE = "value";
    private static final String PROPERTITY_AXIS_PLOTLINES_WIDTH = "width";
    private static final String PROPERTITY_AXIS_PLOTLINES_ZINDEX = "zIndex";
    private static final String PROPERTITY_AXIS_REVERSED = "reversed";
    private static final String PROPERTITY_AXIS_SHOWFIRSTLABEL = "showFirstLabel";
    private static final String PROPERTITY_AXIS_SHOWLASTLABEL = "showLastLabel";
    private static final String PROPERTITY_AXIS_TITLE = "title";
    private static final String PROPERTITY_AXIS_TITLE_ALIGN = "align";
    private static final String PROPERTITY_AXIS_TITLE_MARGIN = "margin";
    private static final String PROPERTITY_AXIS_TITLE_ROTATION = "rotation";
    private static final String PROPERTITY_AXIS_TITLE_STYLE = "style";
    private static final String PROPERTITY_AXIS_TITLE_TEXT = "text";
    private static final String PROPERTITY_AXIS_TYPE = "type";
    private static final String PROPERTITY_AXIS_LABELS = "labels";
    private static final String PROPERTITY_AXIS_LABELS_ALIGN = "align";
    private static final String PROPERTITY_AXIS_LABELS_FORMATTER = "formatter";
    private static final String PROPERTITY_AXIS_LABELS_ROTATION = "rotation";
    private static final String PROPERTITY_AXIS_LABELS_STAGGERLINES = "staggerLines";
    private static final String PROPERTITY_AXIS_LABELS_STEP = "step";
    private static final String PROPERTITY_AXIS_LABELS_STYLE = "style";
    private static final String PROPERTITY_AXIS_LABELS_X = "x";
    private static final String PROPERTITY_AXIS_LABELS_Y = "y";
    private static final String PROPERTITY_PLOTOPTIONS = "plotOptions";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER = "marker";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_ENABLED = "enabled";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_FILLCOLOR = "fillColor";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_LINECOLOR = "lineColor";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_LINEWIDTH = "lineWidth";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_RADIUS = "radius";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_STATES = "states";
    private static final String PROPERTITY_PLOTOPTIONS_MARKER_SYMBOL = "symbol";
    private static final String PROPERTITY_PLOTOPTIONS_DASHSTYLE = "dashStyle";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS = "dataLabels";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_ALIGN = "align";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_COLOR = "color";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_ENABLED = "enabled";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_FORMATTER = "formatter";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_ROTATION = "rotation";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_STYLE = "style";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_X = "x";
    private static final String PROPERTITY_PLOTOPTIONS_DATALABELS_Y = "y";
    private static final String PROPERTITY_PLOTOPTIONS_ALLOWPOINTSELECT = "allowPointSelect";
    private static final String PROPERTITY_PLOTOPTIONS_ANIMATION = "animation";
    private static final String PROPERTITY_PLOTOPTIONS_COLOR = "color";
    private static final String PROPERTITY_PLOTOPTIONS_CURSOR = "cursor";
    private static final String PROPERTITY_PLOTOPTIONS_ENABLEMOUSETRACKING = "enableMouseTracking";
    private static final String PROPERTITY_PLOTOPTIONS_ID = "id";
    private static final String PROPERTITY_PLOTOPTIONS_LINEWIDTH = "lineWidth";
    private static final String PROPERTITY_PLOTOPTIONS_POINT = "point";
    private static final String PROPERTITY_PLOTOPTIONS_POINTSTART = "pointStart";
    private static final String PROPERTITY_PLOTOPTIONS_POINTINTERVAL = "pointInterval";
    private static final String PROPERTITY_PLOTOPTIONS_SELECTED = "selected";
    private static final String PROPERTITY_PLOTOPTIONS_SHADOW = "shadow";
    private static final String PROPERTITY_PLOTOPTIONS_SHOWCHECKBOX = "showCheckbox";
    private static final String PROPERTITY_PLOTOPTIONS_SHOWINLEGEND = "showInLegend";
    private static final String PROPERTITY_PLOTOPTIONS_STACKING = "stacking";
    private static final String PROPERTITY_PLOTOPTIONS_STATES = "states";
    private static final String PROPERTITY_PLOTOPTIONS_STICKYTRACKING = "stickyTracking";
    private static final String PROPERTITY_PLOTOPTIONS_VISIBLE = "visible";
    private static final String PROPERTITY_PLOTOPTIONS_ZINDEX = "zIndex";
    private static final String PROPERTITY_PLOTOPTIONS_STEP = "step";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_BORDERCOLOR = "borderColor";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_BORDERRADIUS = "borderRadius";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_BORDERWIDTH = "borderWidth";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_COLORBYPOINT = "colorByPoint";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_GROUPPADDING = "groupPadding";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_MINPOINTLENGTH = "minPointLength";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_POINTPADDING = "pointPadding";
    private static final String PROPERTITY_PLOTOPTIONS_COLUMN_POINTWIDTH = "pointWidth";
    private static final String PROPERTITY_PLOTOPTIONS_AREA_FILLCOLOR = "fillColor";
    private static final String PROPERTITY_PLOTOPTIONS_AREA_FILLOPACITY = "fillOpacity";
    private static final String PROPERTITY_PLOTOPTIONS_AREA_LINECOLOR = "lineColor";
    private static final String PROPERTITY_PLOTOPTIONS_AREA_THRESHOLD = "threshold";

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        CompositeMap view = context.getView();
        String theme = view.getString(PROPERTITY_THEME.toLowerCase());
        if (theme == null) {
            theme = "grid";
        }
        this.addJavaScript(session, context, "chart/Adapter-min.js");
        this.addJavaScript(session, context, "chart/Chart-min.js");
        this.addJavaScript(session, context, "chart/themes/" + theme + ".js");
        this.addJavaScript(session, context, "chart/Exporting-min.js");
    }

    @Override
    protected void addEvent(String id, String eventName, String handler) {
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        CompositeMap view = context.getView();
        CompositeMap model = context.getModel();
        String bindTarget = view.getString("bindtarget");
        map.put("bindtarget", bindTarget);
        String value = view.getString(PROPERTITY_SERIES_NAME.toLowerCase());
        if (value == null) {
            value = PROPERTITY_AXIS_NAME;
        }
        this.addConfig(PROPERTITY_SERIES_NAME, value);
        map.put("contextPath", model.getObject("/request/@context_path").toString());
        this.processChartConfig(context);
        this.processTitle(context);
        this.processSubTitle(context);
        this.processLegend(context);
        this.processPlotOptions(context);
        this.processTooltip(context);
        this.processLabels(context);
        this.createAxis(context, PROPERTITY_AXIS_X);
        this.createAxis(context, PROPERTITY_AXIS_Y);
        JSONObject config = this.getConfig();
        if (view.getString("height") == null) {
            config.remove("height");
        }
        if (view.getString("width") == null) {
            config.remove("width");
        }
        config.remove("listeners");
        map.put("config", this.getConfigString());
    }

    private void putStringCfg(CompositeMap view, String key, Map map) {
        String value = view.getString(key.toLowerCase());
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putIntCfg(CompositeMap view, String key, Map map) {
        Integer value = view.getInt(key.toLowerCase());
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putLongCfg(CompositeMap view, String key, Map map) {
        Long value = view.getLong(key.toLowerCase());
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putBooleanCfg(CompositeMap view, String key, Map map) {
        Boolean value = view.getBoolean(key.toLowerCase());
        if (value != null) {
            map.put(key, value);
        }
    }

    private void putFunctionCfg(CompositeMap view, String key, Map map) {
        String value = view.getString(key.toLowerCase());
        if (value != null) {
            map.put(key, new JSONFunction(value));
        }
    }

    private void putStyleCfg(CompositeMap view, String key, Map map) {
        String value = view.getString(key.toLowerCase());
        if (value != null) {
            JSONObject smap = new JSONObject();
            String[] sts = value.split(";");
            for (int i = 0; i < sts.length; ++i) {
                String style = sts[i];
                if ("".equals(style) || style.indexOf(":") == -1) continue;
                String[] vs = style.split(":");
                String k = vs[0];
                String v = vs[1];
                v = v.replaceAll("'", "");
                Integer iv = null;
                try {
                    iv = Integer.valueOf(v);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    if (iv == null) {
                        smap.put(k, v);
                        continue;
                    }
                    smap.put(k, iv);
                    continue;
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            map.put(key, smap);
        }
    }

    private void processChartConfig(ViewContext context) {
        HashMap<String, String> chart = new HashMap<String, String>();
        CompositeMap view = context.getView();
        Map map = context.getMap();
        chart.put("renderTo", (String)map.get("id") + "_c");
        this.putStringCfg(view, "type", chart);
        this.putIntCfg(view, "borderWidth", chart);
        this.putIntCfg(view, "borderRadius", chart);
        this.putStringCfg(view, "borderColor", chart);
        this.putStringCfg(view, PROPERTITY_CHART_CLASS_NAME, chart);
        this.putBooleanCfg(view, PROPERTITY_CHART_IGNORE_HIDDEN_SERIES, chart);
        this.putBooleanCfg(view, PROPERTITY_CHART_INVERTED, chart);
        this.putIntCfg(view, PROPERTITY_CHART_MARGIN_TOP, chart);
        this.putIntCfg(view, PROPERTITY_CHART_MARGIN_RIGHT, chart);
        this.putIntCfg(view, PROPERTITY_CHART_MARGIN_LEFT, chart);
        this.putIntCfg(view, PROPERTITY_CHART_MARGIN_BOTTOM, chart);
        this.putStringCfg(view, PROPERTITY_CHART_PLOT_BACKGROUND_COLOR, chart);
        this.putStringCfg(view, PROPERTITY_CHART_PLOT_BACKGROUND_IMAGE, chart);
        this.putStringCfg(view, PROPERTITY_CHART_PLOT_BORDER_COLOR, chart);
        this.putIntCfg(view, PROPERTITY_CHART_PLOT_BORDER_WIDTH, chart);
        this.putBooleanCfg(view, PROPERTITY_CHART_PLOT_SHADOW, chart);
        this.putBooleanCfg(view, PROPERTITY_CHART_REFLOW, chart);
        this.putBooleanCfg(view, "shadow", chart);
        this.putBooleanCfg(view, PROPERTITY_CHART_SHOW_AXES, chart);
        this.putIntCfg(view, PROPERTITY_CHART_SPACING_TOP, chart);
        this.putIntCfg(view, PROPERTITY_CHART_SPACING_RIGHT, chart);
        this.putIntCfg(view, PROPERTITY_CHART_SPACING_BOTTOM, chart);
        this.putIntCfg(view, PROPERTITY_CHART_SPACING_LEFT, chart);
        this.putStyleCfg(view, PROPERTITY_CHART_STYLE, chart);
        this.putStringCfg(view, PROPERTITY_CHART_ZOOM_TYP, chart);
        this.putEvents(context, view, chart);
        this.addConfig("chart", new JSONObject(chart));
    }

    private void putEvents(ViewContext context, CompositeMap view, Map map) {
        List list;
        CompositeMap events = view.getChild("events");
        if (events != null && (list = events.getChilds()) != null) {
            JSONObject eo = new JSONObject();
            for (CompositeMap event : list) {
                EventConfig eventConfig = EventConfig.getInstance(event);
                String eventName = eventConfig.getEventName();
                String handler = eventConfig.getHandler();
                if ("".equals(eventName) || "".equals(handler)) continue;
                try {
                    eo.put(eventName, new JSONFunction(handler));
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            map.put("events", eo);
        }
    }

    private void processTitle(ViewContext context) {
        HashMap title = new HashMap();
        CompositeMap cview = context.getView();
        CompositeMap view = cview.getChild(PROPERTITY_AXIS_TITLE);
        if (view != null) {
            this.putStyleCfg(view, "style", title);
            this.putStringCfg(view, "text", title);
            this.putIntCfg(view, "x", title);
            this.putIntCfg(view, "y", title);
            this.putStringCfg(view, "align", title);
            this.putIntCfg(view, "margin", title);
            this.putBooleanCfg(view, "floating", title);
            this.putStringCfg(view, "verticalAlign", title);
        }
        if (!title.isEmpty()) {
            this.addConfig(PROPERTITY_AXIS_TITLE, new JSONObject(title));
        }
    }

    private void processSubTitle(ViewContext context) {
        HashMap title = new HashMap();
        CompositeMap cview = context.getView();
        CompositeMap view = cview.getChild("subtitle");
        if (view != null) {
            this.putStyleCfg(view, "style", title);
            this.putStringCfg(view, "text", title);
            this.putIntCfg(view, "x", title);
            this.putIntCfg(view, "y", title);
            this.putBooleanCfg(view, "floating", title);
            this.putStringCfg(view, "align", title);
            this.putBooleanCfg(view, "floating", title);
            this.putStringCfg(view, "verticalAlign", title);
        }
        if (!title.isEmpty()) {
            this.addConfig("subtitle", new JSONObject(title));
        }
    }

    private void processLegend(ViewContext context) {
        HashMap cfg = new HashMap();
        CompositeMap cview = context.getView();
        CompositeMap view = cview.getChild("legend");
        if (view != null) {
            this.putStyleCfg(view, PROPERTITY_LEGEND_ITEMSTYLE, cfg);
            this.putStyleCfg(view, "style", cfg);
            this.putStringCfg(view, "align", cfg);
            this.putStringCfg(view, "backgroundColor", cfg);
            this.putStringCfg(view, "borderColor", cfg);
            this.putIntCfg(view, "borderWidth", cfg);
            this.putIntCfg(view, "borderRadius", cfg);
            this.putBooleanCfg(view, "enabled", cfg);
            this.putBooleanCfg(view, "floating", cfg);
            this.putStringCfg(view, PROPERTITY_LEGEND_LAYOUT, cfg);
            this.putFunctionCfg(view, PROPERTITY_LEGEND_LABELFORMATTER, cfg);
            this.putIntCfg(view, "margin", cfg);
            this.putBooleanCfg(view, "reversed", cfg);
            this.putBooleanCfg(view, "shadow", cfg);
            this.putIntCfg(view, PROPERTITY_LEGEND_SYMBOLPADDING, cfg);
            this.putIntCfg(view, PROPERTITY_LEGEND_SYMBOLWIDTH, cfg);
            this.putStringCfg(view, "verticalAlign", cfg);
            this.putIntCfg(view, "width", cfg);
            this.putIntCfg(view, "x", cfg);
            this.putIntCfg(view, "y", cfg);
        }
        if (!cfg.isEmpty()) {
            this.addConfig("legend", new JSONObject(cfg));
        }
    }

    private void processPlotOptions(ViewContext context) {
        List children;
        HashMap<String, JSONObject> cfg = new HashMap<String, JSONObject>();
        CompositeMap cview = context.getView();
        CompositeMap view = cview.getChild(PROPERTITY_PLOTOPTIONS);
        if (view != null && (children = view.getChilds()) != null) {
            for (CompositeMap option : children) {
                String name = option.getName().toLowerCase();
                if ("line".equals(name)) {
                    cfg.put(name, this.processPlotLine(option, context));
                    continue;
                }
                if ("spline".equals(name)) {
                    cfg.put(name, this.processPlotLine(option, context));
                    continue;
                }
                if ("column".equals(name)) {
                    cfg.put(name, this.processPlotColumn(option, context));
                    continue;
                }
                if ("area".equals(name)) {
                    cfg.put(name, this.processPlotArea(option, context));
                    continue;
                }
                if ("areaspline".equals(name)) {
                    cfg.put(name, this.processPlotArea(option, context));
                    continue;
                }
                if (!"pie".equals(name)) continue;
                cfg.put(name, this.processPlotPie(option, context));
            }
        }
        if (!cfg.isEmpty()) {
            this.addConfig(PROPERTITY_PLOTOPTIONS, new JSONObject(cfg));
        }
    }

    private JSONObject processPlotLine(CompositeMap view, ViewContext context) {
        HashMap cfg = new HashMap();
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ALLOWPOINTSELECT, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ANIMATION, cfg);
        this.putStringCfg(view, "color", cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_CURSOR, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_DASHSTYLE, cfg);
        this.processPlotDataLabels(view, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ENABLEMOUSETRACKING, cfg);
        this.putStringCfg(view, "id", cfg);
        this.putIntCfg(view, "lineWidth", cfg);
        this.processPlotMarker(view, cfg);
        this.putLongCfg(view, PROPERTITY_PLOTOPTIONS_POINTSTART, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_POINTINTERVAL, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SELECTED, cfg);
        this.putBooleanCfg(view, "shadow", cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SHOWCHECKBOX, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SHOWINLEGEND, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_STACKING, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_STICKYTRACKING, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_VISIBLE, cfg);
        this.putIntCfg(view, "zIndex", cfg);
        this.putIntCfg(view, "step", cfg);
        return new JSONObject(cfg);
    }

    private JSONObject processPlotColumn(CompositeMap view, ViewContext context) {
        HashMap cfg = new HashMap();
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ALLOWPOINTSELECT, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ANIMATION, cfg);
        this.putStringCfg(view, "color", cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_CURSOR, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_DASHSTYLE, cfg);
        this.processPlotDataLabels(view, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ENABLEMOUSETRACKING, cfg);
        this.putStringCfg(view, "id", cfg);
        this.putIntCfg(view, "lineWidth", cfg);
        this.processPlotMarker(view, cfg);
        this.putLongCfg(view, PROPERTITY_PLOTOPTIONS_POINTSTART, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_POINTINTERVAL, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SELECTED, cfg);
        this.putBooleanCfg(view, "shadow", cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SHOWCHECKBOX, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SHOWINLEGEND, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_STACKING, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_STICKYTRACKING, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_VISIBLE, cfg);
        this.putIntCfg(view, "zIndex", cfg);
        this.putStringCfg(view, "borderColor", cfg);
        this.putIntCfg(view, "borderRadius", cfg);
        this.putIntCfg(view, "borderWidth", cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_COLUMN_COLORBYPOINT, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_COLUMN_GROUPPADDING, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_COLUMN_MINPOINTLENGTH, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_COLUMN_POINTPADDING, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_COLUMN_POINTWIDTH, cfg);
        return new JSONObject(cfg);
    }

    private JSONObject processPlotArea(CompositeMap view, ViewContext context) {
        HashMap cfg = new HashMap();
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ALLOWPOINTSELECT, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ANIMATION, cfg);
        this.putStringCfg(view, "color", cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_CURSOR, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_DASHSTYLE, cfg);
        this.processPlotDataLabels(view, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ENABLEMOUSETRACKING, cfg);
        this.putStringCfg(view, "id", cfg);
        this.putIntCfg(view, "lineWidth", cfg);
        this.processPlotMarker(view, cfg);
        this.putLongCfg(view, PROPERTITY_PLOTOPTIONS_POINTSTART, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_POINTINTERVAL, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SELECTED, cfg);
        this.putBooleanCfg(view, "shadow", cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SHOWCHECKBOX, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SHOWINLEGEND, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_STACKING, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_STICKYTRACKING, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_VISIBLE, cfg);
        this.putIntCfg(view, "zIndex", cfg);
        this.processFillColor(view, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_AREA_FILLOPACITY, cfg);
        this.putStringCfg(view, "lineColor", cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_AREA_THRESHOLD, cfg);
        return new JSONObject(cfg);
    }

    private JSONObject processPlotPie(CompositeMap view, ViewContext context) {
        HashMap cfg = new HashMap();
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ALLOWPOINTSELECT, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ANIMATION, cfg);
        this.putStringCfg(view, "color", cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_CURSOR, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_DASHSTYLE, cfg);
        this.processPlotDataLabels(view, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_ENABLEMOUSETRACKING, cfg);
        this.putStringCfg(view, "id", cfg);
        this.putIntCfg(view, "lineWidth", cfg);
        this.processPlotMarker(view, cfg);
        this.putLongCfg(view, PROPERTITY_PLOTOPTIONS_POINTSTART, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_POINTINTERVAL, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SELECTED, cfg);
        this.putBooleanCfg(view, "shadow", cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SHOWCHECKBOX, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_SHOWINLEGEND, cfg);
        this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_STACKING, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_STICKYTRACKING, cfg);
        this.putBooleanCfg(view, PROPERTITY_PLOTOPTIONS_VISIBLE, cfg);
        this.putIntCfg(view, "zIndex", cfg);
        this.processFillColor(view, cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_AREA_FILLOPACITY, cfg);
        this.putStringCfg(view, "lineColor", cfg);
        this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_AREA_THRESHOLD, cfg);
        return new JSONObject(cfg);
    }

    private void processFillColor(CompositeMap parent, Map map) {
        HashMap<String, JSONArray> cfg = new HashMap<String, JSONArray>();
        String linearGradient = "linearGradient";
        String stops = "stops";
        CompositeMap view = parent.getChild("fillColor");
        if (view != null) {
            List list;
            CompositeMap stps;
            List list2;
            CompositeMap lg = view.getChild(linearGradient);
            if (lg != null && (list2 = lg.getChilds()) != null) {
                JSONArray array = new JSONArray();
                for (CompositeMap v : list2) {
                    array.put(v.getInt(PROPERTITY_AXIS_PLOTLINES_VALUE));
                }
                cfg.put(linearGradient, array);
            }
            if ((stps = view.getChild(stops)) != null && (list = stps.getChilds()) != null) {
                JSONArray array = new JSONArray();
                for (CompositeMap v : list) {
                    JSONArray item = new JSONArray();
                    item.put(v.getInt(PROPERTITY_AXIS_NAME));
                    item.put(v.getString(PROPERTITY_AXIS_PLOTLINES_VALUE));
                    array.put(item);
                }
                cfg.put(stops, array);
            }
            map.put("fillColor", new JSONObject(cfg));
        }
    }

    private void processPlotMarker(CompositeMap parent, Map map) {
        HashMap cfg = new HashMap();
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_MARKER);
        if (view != null) {
            this.putBooleanCfg(view, "enabled", cfg);
            this.putStringCfg(view, "fillColor", cfg);
            this.putStringCfg(view, "lineColor", cfg);
            this.putIntCfg(view, "lineWidth", cfg);
            this.putIntCfg(view, PROPERTITY_PLOTOPTIONS_MARKER_RADIUS, cfg);
            this.putStringCfg(view, PROPERTITY_PLOTOPTIONS_MARKER_SYMBOL, cfg);
            map.put(PROPERTITY_PLOTOPTIONS_MARKER, new JSONObject(cfg));
        }
    }

    private void processPlotDataLabels(CompositeMap parent, Map map) {
        HashMap cfg = new HashMap();
        CompositeMap view = parent.getChild(PROPERTITY_PLOTOPTIONS_DATALABELS);
        if (view != null) {
            this.putStringCfg(view, "align", cfg);
            this.putStringCfg(view, "color", cfg);
            this.putBooleanCfg(view, "enabled", cfg);
            this.putFunctionCfg(view, "formatter", cfg);
            this.putIntCfg(view, "rotation", cfg);
            this.putStyleCfg(view, "style", cfg);
            this.putIntCfg(view, "x", cfg);
            this.putIntCfg(view, "y", cfg);
            map.put(PROPERTITY_PLOTOPTIONS_DATALABELS, new JSONObject(cfg));
        }
    }

    private void processTooltip(ViewContext context) {
        HashMap cfg = new HashMap();
        CompositeMap cview = context.getView();
        CompositeMap view = cview.getChild("tooltip");
        if (view != null) {
            this.putStringCfg(view, "backgroundColor", cfg);
            this.putStringCfg(view, "borderColor", cfg);
            this.putIntCfg(view, "borderRadius", cfg);
            this.putIntCfg(view, "borderWidth", cfg);
            this.putBooleanCfg(view, "enabled", cfg);
            this.putFunctionCfg(view, "formatter", cfg);
            this.putBooleanCfg(view, "shadow", cfg);
            this.putBooleanCfg(view, PROPERTITY_TOOLTIP_SHARED, cfg);
            this.putIntCfg(view, PROPERTITY_TOOLTIP_SNAP, cfg);
            this.putStyleCfg(view, "style", cfg);
        }
        if (!cfg.isEmpty()) {
            this.addConfig("tooltip", new JSONObject(cfg));
        }
    }

    private void processLabels(ViewContext context) {
        HashMap cfg = new HashMap();
        CompositeMap cview = context.getView();
        CompositeMap view = cview.getChild("labels");
        JSONArray array = null;
        if (view != null) {
            this.putStyleCfg(view, "style", cfg);
            List list = view.getChilds();
            if (list != null) {
                array = new JSONArray();
                for (CompositeMap label : list) {
                    HashMap icfg = new HashMap();
                    this.putStringCfg(label, PROPERTITY_LABELS_LABEL_HTML, icfg);
                    this.putStyleCfg(label, "style", icfg);
                    array.put(icfg);
                }
            }
        }
        if (array != null) {
            this.addConfig("labels", array);
        }
    }

    private void createLabels(CompositeMap cview, Map map) {
        CompositeMap view = cview.getChild("labels");
        HashMap cfg = new HashMap();
        if (view != null) {
            this.putStringCfg(view, "align", cfg);
            this.putFunctionCfg(view, "formatter", cfg);
            this.putIntCfg(view, "rotation", cfg);
            this.putIntCfg(view, PROPERTITY_AXIS_LABELS_STAGGERLINES, cfg);
            this.putIntCfg(view, "step", cfg);
            this.putStyleCfg(view, "style", cfg);
            this.putIntCfg(view, "x", cfg);
            this.putIntCfg(view, "y", cfg);
        }
        if (!cfg.isEmpty()) {
            map.put("labels", new JSONObject(cfg));
        }
    }

    private void createAxis(ViewContext context, String name) {
        CompositeMap view = context.getView();
        CompositeMap axis = view.getChild(name);
        if (axis != null) {
            List list = axis.getChilds();
            JSONArray array = null;
            if (list != null) {
                array = new JSONArray();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    HashMap cfg = new HashMap();
                    CompositeMap axi = (CompositeMap)it.next();
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_ALLOWDECIMALS, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_ALTERNATEGRIDCOLOR, cfg);
                    this.createCategories(axi, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_GRIDLINECOLOR, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_GRIDLINEDASHSTYLE, cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_GRIDLINEWIDTH, cfg);
                    this.putStringCfg(axi, "id", cfg);
                    this.createLabels(axi, cfg);
                    this.putStringCfg(axi, "lineColor", cfg);
                    this.putIntCfg(axi, "lineWidth", cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_LINKTO, cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_MAX, cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_MAXPADDING, cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_MAXZOOM, cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_MIN, cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_MINPADDING, cfg);
                    this.putIntCfg(axi, PROPERTITY_AXIS_OFFSET, cfg);
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_OPPOSITE, cfg);
                    this.putStringCfg(axi, PROPERTITY_AXIS_NAME, cfg);
                    this.creatPlotBands(axi, cfg);
                    this.creatPlotLines(axi, cfg);
                    this.putBooleanCfg(axi, "reversed", cfg);
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_SHOWFIRSTLABEL, cfg);
                    this.putBooleanCfg(axi, PROPERTITY_AXIS_SHOWLASTLABEL, cfg);
                    this.putStringCfg(axi, "lineColor", cfg);
                    this.createTitle(axi, cfg);
                    this.putStringCfg(axi, "type", cfg);
                    array.put(cfg);
                }
                if (array != null) {
                    this.addConfig(name, array);
                }
            }
        }
    }

    private void createCategories(CompositeMap view, Map map) {
        CompositeMap cats = view.getChild(PROPERTITY_AXIS_CAGEGORIES);
        if (cats != null) {
            List list = cats.getChilds();
            JSONArray array = null;
            if (list != null) {
                array = new JSONArray();
                for (CompositeMap cat : list) {
                    String value = cat.getString(PROPERTITY_AXIS_PLOTLINES_VALUE, "");
                    array.put(value);
                }
                if (array != null) {
                    map.put(PROPERTITY_AXIS_CAGEGORIES, array);
                }
            }
        }
    }

    private void creatPlotBands(CompositeMap view, Map map) {
        CompositeMap pbs = view.getChild(PROPERTITY_AXIS_PLOTBANDS);
        if (pbs != null) {
            List list = pbs.getChilds();
            JSONArray array = null;
            if (list != null) {
                array = new JSONArray();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    HashMap cfg = new HashMap();
                    CompositeMap pb = (CompositeMap)it.next();
                    this.putStringCfg(pb, "color", cfg);
                    this.putIntCfg(pb, PROPERTITY_AXIS_PLOTBANDS_FROM, cfg);
                    this.putStringCfg(pb, "id", cfg);
                    this.createPlotLabel(pb, cfg);
                    this.putIntCfg(pb, PROPERTITY_AXIS_PLOTBANDS_TO, cfg);
                    this.putIntCfg(pb, "zIndex", cfg);
                    array.put(cfg);
                }
                if (array != null) {
                    map.put(PROPERTITY_AXIS_PLOTBANDS, array);
                }
            }
        }
    }

    private void creatPlotLines(CompositeMap view, Map map) {
        CompositeMap pls = view.getChild(PROPERTITY_AXIS_PLOTLINES);
        if (pls != null) {
            List list = pls.getChilds();
            JSONArray array = null;
            if (list != null) {
                array = new JSONArray();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    HashMap cfg = new HashMap();
                    CompositeMap pl = (CompositeMap)it.next();
                    this.putStringCfg(pl, "color", cfg);
                    this.putStringCfg(pl, "id", cfg);
                    this.putIntCfg(pl, PROPERTITY_AXIS_PLOTLINES_VALUE, cfg);
                    this.putIntCfg(pl, "width", cfg);
                    this.createPlotLabel(pl, cfg);
                    this.putIntCfg(pl, "zIndex", cfg);
                    array.put(cfg);
                }
                if (array != null) {
                    map.put(PROPERTITY_AXIS_PLOTLINES, array);
                }
            }
        }
    }

    private void createPlotLabel(CompositeMap view, Map map) {
        CompositeMap label = view.getChild(PROPERTITY_AXIS_PLOT_LABEL);
        if (label != null) {
            HashMap cfg = new HashMap();
            this.putStringCfg(label, "align", cfg);
            this.putStringCfg(label, "text", cfg);
            this.putStringCfg(label, "verticalAlign", cfg);
            this.putIntCfg(label, "rotation", cfg);
            this.putStyleCfg(label, "style", cfg);
            this.putStringCfg(label, PROPERTITY_AXIS_PLOT_LABEL_TEXTALIGN, cfg);
            this.putIntCfg(label, "x", cfg);
            this.putIntCfg(label, "y", cfg);
            map.put(PROPERTITY_AXIS_PLOT_LABEL, new JSONObject(cfg));
        }
    }

    private void createTitle(CompositeMap view, Map map) {
        CompositeMap title = view.getChild(PROPERTITY_AXIS_TITLE);
        if (title != null) {
            HashMap cfg = new HashMap();
            this.putStringCfg(title, "align", cfg);
            this.putIntCfg(title, "margin", cfg);
            this.putStyleCfg(title, "style", cfg);
            this.putIntCfg(title, "rotation", cfg);
            this.putStringCfg(title, "text", cfg);
            map.put(PROPERTITY_AXIS_TITLE, new JSONObject(cfg));
        }
    }
}

