/*
 * Decompiled with CFR 0.152.
 */
package aurora.application.admin;

import aurora.application.admin.ServerAdmin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;

public class CommandHandleThread
extends Thread {
    ServerAdmin mOwner;
    Socket mSocket;
    InputStream mInput;
    OutputStream mOutput;
    boolean mRunning = true;

    public CommandHandleThread(ServerAdmin owner, Socket socket) throws IOException {
        this.mOwner = owner;
        this.mSocket = socket;
        this.mInput = this.mSocket.getInputStream();
        this.mOutput = this.mSocket.getOutputStream();
    }

    @Override
    public void run() {
        while (this.mRunning) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.mInput));
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(this.mOutput));
                String command = reader.readLine();
                command = command.trim();
                if ("stop".equalsIgnoreCase(command)) {
                    writer.println("Shutting down...");
                    this.mOwner.doShutdown();
                    writer.println("OK");
                    return;
                }
                if ("exit".equalsIgnoreCase(command)) {
                    writer.println("Bye!");
                    this.mOwner.removeClient(this);
                    return;
                }
                writer.println("Unkown command:" + command);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    void closeStream(InputStream s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void closeStream(OutputStream s) {
        if (s != null) {
            try {
                s.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void closeClient() {
        this.mOwner.removeClient(this);
    }

    public void clearUp() {
        this.closeStream(this.mInput);
        this.closeStream(this.mOutput);
        if (this.mSocket != null) {
            try {
                this.mSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

