/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.sap.sync.idoc;

import aurora.plugin.sap.sync.idoc.AuroraIDocException;
import aurora.plugin.sap.sync.idoc.IDocFile;
import aurora.plugin.sap.sync.idoc.IDocServer;
import aurora.plugin.sap.sync.idoc.IDocType;
import aurora.plugin.sap.sync.idoc.LoggerUtil;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;

public class IDocSync
extends Thread {
    public static final String SYNC = "sync";
    public IDocServer iDocServer;
    public List errorIdocTypes = new LinkedList();
    public IDocType idocType;

    public IDocSync(IDocServer iDocServer) {
        this.iDocServer = iDocServer;
    }

    @Override
    public void run() {
        while (this.isServerRunning()) {
            this.idocType = null;
            IDocFile file = this.iDocServer.getSyncFile();
            if (file == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.iDocServer.log(e);
                }
                continue;
            }
            int header_id = -1;
            String context = "middle";
            try {
                header_id = this.insertMiddleTables(file);
                context = "formal";
                this.insertFormalTables(file, header_id);
                this.iDocServer.addBackupFile(file);
            }
            catch (Throwable e) {
                this.iDocServer.log(e);
                try {
                    String errorMessage = context + " failed";
                    LoggerUtil.getLogger().log("updateIdocStatus for idoc:" + file.getIdocId() + " " + errorMessage);
                    this.iDocServer.getDbUtil().updateIdocStatus(header_id, file.getIdocId(), errorMessage);
                }
                catch (AuroraIDocException e1) {
                    this.iDocServer.log(e1);
                }
            }
        }
    }

    private int insertMiddleTables(IDocFile file) throws AuroraIDocException {
        int header_id = this.iDocServer.getDbUtil().existHeaders(file.getIdocId());
        try {
            if (header_id == -1) {
                CompositeLoader loader = new CompositeLoader();
                CompositeMap iDocData = loader.loadByFile(file.getPath());
                if (iDocData.getChilds() == null) {
                    int n = header_id;
                    return n;
                }
                Iterator it = iDocData.getChildIterator();
                while (it.hasNext()) {
                    CompositeMap idoc_node = (CompositeMap)it.next();
                    if (idoc_node == null || idoc_node.getChildIterator() == null || idoc_node.getChilds().size() < 2) {
                        int n = header_id;
                        return n;
                    }
                    CompositeMap control_node = (CompositeMap)idoc_node.getChilds().get(0);
                    if (header_id == -1) {
                        this.idocType = this.iDocServer.getDbUtil().getIdocType(control_node);
                        if (this.isIdocTypeStop()) {
                            throw new AuroraIDocException("This idocType:" + this.idocType + " has error before");
                        }
                        header_id = this.iDocServer.getDbUtil().registerInterfaceHeader(file.getIdocId(), control_node);
                        this.iDocServer.getDbUtil().updateIdocInfo(file.getIdocId(), control_node);
                    }
                    for (int i = 1; i < idoc_node.getChilds().size(); ++i) {
                        CompositeMap content_node = (CompositeMap)idoc_node.getChilds().get(i);
                        this.iDocServer.getDbUtil().registerMiddleLine(header_id, content_node);
                    }
                }
                this.iDocServer.getDbUtil().getConnection().commit();
            }
        }
        catch (Throwable e) {
            this.iDocServer.getDbUtil().rollbackConnection();
            throw new AuroraIDocException(e);
        }
        finally {
            this.iDocServer.getDbUtil().setConnectionAutoCommit(true);
        }
        return header_id;
    }

    private void insertFormalTables(IDocFile file, int header_id) throws SQLException, AuroraIDocException {
        String executePkg = this.iDocServer.getDbUtil().getFormalExecutePkg(file.getIdocId());
        String errorMessage = this.iDocServer.getDbUtil().executePkg(executePkg, header_id);
        if (errorMessage != null && !"".equals(errorMessage)) {
            throw new AuroraIDocException("execute Formal Pkg " + executePkg + " failed:" + errorMessage);
        }
        this.iDocServer.getDbUtil().updateIdocStatus(header_id, file.getIdocId(), "done");
    }

    public boolean isServerRunning() {
        return this.iDocServer.isRunning();
    }

    private boolean isIdocTypeStop() throws SQLException, AuroraIDocException {
        String handleModel = this.iDocServer.getDbUtil().getHandleModel(this.idocType.getIdoctyp(), this.idocType.getCimtyp());
        return SYNC.equals(handleModel) && this.errorIdocTypes.contains(this.idocType);
    }
}

