/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.memcached;

import aurora.plugin.memcached.MemcachedClientWrapper;
import java.io.IOException;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import uncertain.cache.ICache;
import uncertain.cache.ICacheReader;
import uncertain.cache.ICacheWriter;
import uncertain.cache.INamedCacheFactory;
import uncertain.core.ILifeCycle;
import uncertain.ocm.IConfigureListener;

public class MemcachedClientFactory
implements INamedCacheFactory,
IConfigureListener,
ILifeCycle {
    MemcachedClient mClient;
    String mServerList;
    MemcachedClientWrapper mDefaultWrapper;
    String mName;
    int operationTimeout;
    boolean addNameToKey;

    private MemcachedClientWrapper createWrapper(String name) {
        MemcachedClientWrapper wrapper = new MemcachedClientWrapper(name, this.mClient);
        return wrapper;
    }

    public String getServerList() {
        return this.mServerList;
    }

    public void setServerList(String serverList) {
        this.mServerList = serverList;
    }

    public ICacheReader getCacheReader() {
        return this.mDefaultWrapper;
    }

    public ICacheWriter getCacheWriter() {
        return this.mDefaultWrapper;
    }

    public ICache getCache() {
        return this.mDefaultWrapper;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public boolean isCacheEnabled(String name) {
        return true;
    }

    public ICache getNamedCache(String name) {
        return this.createWrapper(name);
    }

    public void endConfigure() {
        this.startup();
    }

    public boolean startup() {
        try {
            this.mClient = new MemcachedClient((ConnectionFactory)new BinaryConnectionFactory(), AddrUtil.getAddresses((String)this.mServerList));
            this.mDefaultWrapper = this.createWrapper(null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        return true;
    }

    public void shutdown() {
        if (this.mClient != null) {
            this.mClient.shutdown();
        }
        this.mClient = null;
        this.mDefaultWrapper = null;
    }
}

