/*
 * Decompiled with CFR 0.152.
 */
package aurora.plugin.amq;

import aurora.plugin.jms.Consumer;
import aurora.plugin.jms.IMessageHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import uncertain.composite.CompositeMap;
import uncertain.exception.BuiltinExceptionFactory;
import uncertain.exception.MessageFactory;
import uncertain.logging.ILogger;
import uncertain.logging.LoggingContext;
import uncertain.ocm.IConfigurable;
import uncertain.ocm.IObjectRegistry;
import uncertain.util.resource.ILocatable;

public class AMQClientInstance
implements IConfigurable {
    public static final String PLUGIN = "aurora.plugin.amq";
    private IMessageHandler[] mMessageHandlers;
    private Consumer[] consumers;
    private CompositeMap config;
    private String url;
    private IObjectRegistry registry;
    public ILogger logger;
    private Map handlersMap = new HashMap();
    private ActiveMQConnectionFactory factory;

    public AMQClientInstance(IObjectRegistry registry) {
        this.registry = registry;
    }

    public void onInitialize() throws Exception {
        this.logger = LoggingContext.getLogger((String)PLUGIN, (IObjectRegistry)this.registry);
        MessageFactory.loadResource((String)"resources.aurora_plugin_amq");
        if (this.url == null) {
            BuiltinExceptionFactory.createOneAttributeMissing((ILocatable)this.config.asLocatable(), (String)"url");
        }
        this.factory = new ActiveMQConnectionFactory(this.url);
        this.registry.registerInstance(ConnectionFactory.class, (Object)this.factory);
        new Thread(){

            @Override
            public void run() {
                if (AMQClientInstance.this.consumers != null) {
                    for (int i = 0; i < AMQClientInstance.this.consumers.length; ++i) {
                        try {
                            AMQClientInstance.this.consumers[i].init((ConnectionFactory)AMQClientInstance.this.factory, AMQClientInstance.this.handlersMap);
                            continue;
                        }
                        catch (Exception e) {
                            AMQClientInstance.this.logger.log(Level.SEVERE, "init jms consumers failed!", (Throwable)e);
                        }
                    }
                }
            }
        }.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    AMQClientInstance.this.onShutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void onShutdown() throws Exception {
        if (this.consumers != null) {
            for (int i = 0; i < this.consumers.length; ++i) {
                this.consumers[i].onShutdown();
            }
        }
    }

    public IMessageHandler getMessageHandler(String name) {
        return (IMessageHandler)this.handlersMap.get(name);
    }

    public void beginConfigure(CompositeMap config) {
        this.config = config;
    }

    public void endConfigure() {
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public IMessageHandler[] getMessageHandlers() {
        return this.mMessageHandlers;
    }

    public void setMessageHandlers(IMessageHandler[] messageHandlers) {
        this.mMessageHandlers = messageHandlers;
        for (int i = 0; i < messageHandlers.length; ++i) {
            this.handlersMap.put(messageHandlers[i].getName(), messageHandlers[i]);
        }
    }

    public Consumer[] getConsumers() {
        return this.consumers;
    }

    public void setConsumers(Consumer[] consumers) {
        this.consumers = consumers;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public ActiveMQConnectionFactory getFactory() {
        return this.factory;
    }

    public void setFactory(ActiveMQConnectionFactory factory) {
        this.factory = factory;
    }
}

