/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.sxsd.editor;

import aurora.ide.helpers.LocaleMessage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class SxsdNewWizardPage
extends WizardPage {
    public static final String FILE_EXT = "sxsd";
    private Text containerText;
    private Text fileText;
    private Text namespacePrefix;
    private Text namespaceUrl;
    private ISelection selection;

    public SxsdNewWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(LocaleMessage.getString("sxsd.wizard"));
        this.setDescription(LocaleMessage.getString("sxsd.wizard.desc"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(LocaleMessage.getString("container"));
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SxsdNewWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(LocaleMessage.getString("openBrowse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SxsdNewWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(LocaleMessage.getString("file.name"));
        this.fileText = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gd);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SxsdNewWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(LocaleMessage.getString("namespace.prefix"));
        this.namespacePrefix = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.namespacePrefix.setLayoutData((Object)gd);
        this.namespacePrefix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SxsdNewWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        label.setText(LocaleMessage.getString("namespace.url"));
        this.namespaceUrl = new Text(container, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.namespaceUrl.setLayoutData((Object)gd);
        this.namespaceUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SxsdNewWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IContainer container = obj instanceof IContainer ? (IContainer)obj : ((IResource)obj).getParent();
                this.containerText.setText(container.getFullPath().toString());
            }
        }
        this.namespacePrefix.setText(FILE_EXT);
        this.namespaceUrl.setText("http://www.uncertain-framework.org/schema/simple-schema");
    }

    private void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, LocaleMessage.getString("select.new.file.container"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(((Path)result[0]).toString());
        }
    }

    private void dialogChanged() {
        String ext;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus(LocaleMessage.getString("file.container.must.be.specified"));
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus(LocaleMessage.getString("file.container.must.exist"));
            return;
        }
        if (fileName != null && !fileName.equals("") && ((IContainer)container).getFile((IPath)new Path(fileName)).exists()) {
            this.updateStatus(LocaleMessage.getString("filename.used"));
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(LocaleMessage.getString("project.must.be.writable"));
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(LocaleMessage.getString("file.name.must.be.specified"));
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus(LocaleMessage.getString("file.name.must.be.valid"));
            return;
        }
        int dotLoc = fileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = fileName.substring(dotLoc + 1)).equalsIgnoreCase(FILE_EXT)) {
            this.updateStatus(LocaleMessage.getString("file.extension.must.be.sxsd"));
            return;
        }
        if (this.getNamespacePrefix().length() == 0) {
            this.updateStatus(LocaleMessage.getString("namespace.prefix.must.be.specified"));
            return;
        }
        if (this.getNamespaceUrl().length() == 0) {
            this.updateStatus(LocaleMessage.getString("namespace.url.must.be.specified"));
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public String getFileName() {
        String fileName = this.fileText.getText();
        if (fileName.indexOf(".") == -1) {
            fileName = String.valueOf(fileName) + "." + FILE_EXT;
        }
        return fileName;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix.getText();
    }

    public String getNamespaceUrl() {
        return this.namespaceUrl.getText();
    }
}

