/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.statistics.wizard.dialog;

import aurora.ide.AuroraPlugin;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DBManager;
import aurora.ide.statistics.wizard.dialog.ConnectionInfo;
import aurora.ide.statistics.wizard.dialog.SecondLoadDataWizardPage;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FirstLoadDataWizardPage
extends WizardPage {
    private Map<String, ConnectionInfo> info = new HashMap<String, ConnectionInfo>();
    private Combo comProjectName;
    private Text txtConnectionInfo;

    public FirstLoadDataWizardPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    /*
     * Loose catch block
     */
    public void init() {
        IProject[] iProjectArray = this.getAuroraProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block19: {
                IProject p = iProjectArray[n2];
                DBManager db = new DBManager(p);
                Connection con = null;
                try {
                    con = db.getConnection();
                    DatabaseMetaData metaData = con.getMetaData();
                    this.comProjectName.add(p.getName());
                    this.info.put(p.getName(), new ConnectionInfo(p, metaData.getUserName(), metaData.getURL(), metaData.getDriverName(), metaData.getDriverVersion()));
                }
                catch (SQLException sQLException) {
                    try {
                        if (con != null) {
                            con.close();
                        }
                        break block19;
                    }
                    catch (SQLException sQLException2) {}
                    break block19;
                }
                catch (ApplicationException applicationException) {
                    try {
                        if (con != null) {
                            con.close();
                        }
                        break block19;
                    }
                    catch (SQLException sQLException) {}
                    break block19;
                    catch (Throwable throwable) {
                        try {
                            if (con != null) {
                                con.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        this.setTitle("\u8f7d\u5165\u6570\u636e");
        this.setDescription("\u9009\u62e9\u8fde\u63a5");
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        container.setLayout((Layout)gridLayout);
        Label lalProjectName = new Label(container, 0);
        lalProjectName.setText("\u5de5\u7a0b\u540d\uff1a");
        this.comProjectName = new Combo(container, 12);
        GridData gdProjectName = new GridData(768);
        this.comProjectName.setLayoutData((Object)gdProjectName);
        this.comProjectName.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FirstLoadDataWizardPage.this.fillInfo(FirstLoadDataWizardPage.this.comProjectName.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lalConnectionInfo = new Label(container, 0);
        GridData gdLabelConnectionInfo = new GridData();
        gdLabelConnectionInfo.verticalAlignment = 128;
        lalConnectionInfo.setText("\u8fde\u63a5\u4fe1\u606f\uff1a");
        lalConnectionInfo.setLayoutData((Object)gdLabelConnectionInfo);
        GridData gdConnectionInfo = new GridData(1808);
        this.txtConnectionInfo = new Text(container, 2824);
        this.txtConnectionInfo.setLayoutData((Object)gdConnectionInfo);
        this.setControl((Control)container);
    }

    private void fillInfo(String projectName) {
        final ConnectionInfo cInfo = this.info.get(projectName);
        String s = "User\uff1a" + cInfo.getUserName() + "\nURL\uff1a" + cInfo.getURL() + "\nDriver\uff1a" + cInfo.getDriverName() + " " + cInfo.getDriverVersion();
        this.txtConnectionInfo.setText(s);
        this.setPageComplete(true);
        final SecondLoadDataWizardPage page = (SecondLoadDataWizardPage)this.getNextPage();
        page.clear();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                page.init(cInfo.getProject());
            }
        });
    }

    private IProject[] getAuroraProjects() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = AuroraPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (this.isAuroraProject(p)) {
                projects.add(p);
            }
            ++n2;
        }
        return projects.toArray(new IProject[projects.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAuroraProject(IProject project) {
        try {
            String[] stringArray = project.getDescription().getNatureIds();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String nature = stringArray[n2];
                if ("aurora.ide.auroranature".equals(nature)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            return false;
        }
    }
}

