/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.statistics.viewer;

import aurora.ide.api.statistics.map.ObjectStatisticsResult;
import aurora.ide.api.statistics.map.StatisticsResult;
import aurora.ide.api.statistics.model.ProjectObject;
import aurora.ide.statistics.viewer.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class ObjectViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    ObjectViewContentProvider() {
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ObjectStatisticsResult) {
            ObjectStatisticsResult osr = (ObjectStatisticsResult)parentElement;
            ArrayList<ObjectNode> nodes = new ArrayList<ObjectNode>();
            List objects = osr.getObjects();
            for (ProjectObject o : objects) {
                nodes.add(this.createObjectNode(o, osr));
            }
            return nodes.toArray(new ObjectNode[nodes.size()]);
        }
        return null;
    }

    private ObjectNode createObjectNode(ProjectObject o, ObjectStatisticsResult osr) {
        ObjectNode on = new ObjectNode();
        on.category = o.getType();
        on.fileName = o.getName();
        on.fileSize = this.toString(o.getFileSize());
        on.parent = osr;
        on.path = o.getPath();
        on.refInCount = Integer.toString(o.getDependencies().size());
        on.refOutCount = Integer.toString(o.getReferenced());
        on.scriptSize = this.toString(o.getScriptSize());
        on.tagCount = this.toString(o.getTags().size());
        return on;
    }

    private String toString(int i) {
        return String.valueOf(i);
    }

    public Object getParent(Object element) {
        if (element instanceof ObjectNode) {
            return ((ObjectNode)element).parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof ObjectStatisticsResult;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof StatisticsResult) {
            ObjectStatisticsResult bmStatisticsResult = ((StatisticsResult)inputElement).getBMStatisticsResult();
            ObjectStatisticsResult sreenStatisticsResult = ((StatisticsResult)inputElement).getSreenStatisticsResult();
            ObjectStatisticsResult svcStatisticsResult = ((StatisticsResult)inputElement).getSVCStatisticsResult();
            ArrayList<ObjectStatisticsResult> result = new ArrayList<ObjectStatisticsResult>();
            if (bmStatisticsResult != null) {
                result.add(bmStatisticsResult);
            }
            if (sreenStatisticsResult != null) {
                result.add(sreenStatisticsResult);
            }
            if (svcStatisticsResult != null) {
                result.add(svcStatisticsResult);
            }
            return result.toArray(new Object[result.size()]);
        }
        return null;
    }
}

