/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.statistics.viewer;

import aurora.ide.api.statistics.IStatisticsManager;
import aurora.ide.api.statistics.Statistician;
import aurora.ide.api.statistics.map.StatisticsResult;
import aurora.ide.api.statistics.model.StatisticsProject;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DBManager;
import aurora.ide.statistics.viewer.ObjectDependency;
import aurora.ide.statistics.viewer.StatisticsView;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LoadFromDBJob
extends Job {
    private StatisticsProject statisticsProject;
    private IProject project;
    private StatisticsView statisticsView;

    public LoadFromDBJob(IProject project, StatisticsProject statisticsProject, StatisticsView statisticsView) {
        super("\u4ece\u6570\u636e\u5e93\u52a0\u8f7d\u6570\u636e");
        this.project = project;
        this.statisticsProject = statisticsProject;
        this.statisticsView = statisticsView;
    }

    protected IStatus run(IProgressMonitor monitor) {
        DBManager dm = new DBManager(this.project);
        Connection connection = null;
        monitor.beginTask("\u6570\u636e\u8bfb\u53d6\u4e2d....", 80);
        try {
            try {
                monitor.worked(10);
                monitor.setTaskName("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5");
                connection = dm.getConnection();
                Statistician s = new Statistician(this.statisticsProject, null, (IStatisticsManager)ObjectDependency.getInstance());
                monitor.worked(20);
                monitor.setTaskName("\u8bfb\u53d6\u7edf\u8ba1\u6570\u636e");
                StatisticsResult read = s.read(connection);
                monitor.worked(40);
                this.statisticsView.setInput(read, s);
                this.statisticsView.setSaveToXLSActionEnabled(true);
            }
            catch (ApplicationException e) {
                this.showMessage(e.getMessage());
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("ORA-00942")) {
                    this.showMessage("\u8868\u6216\u89c6\u56fe\u4e0d\u5b58\u5728");
                }
                e.printStackTrace();
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return Status.OK_STATUS;
    }

    private void showMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"\u7edf\u8ba1\u5206\u6790", (String)message);
            }
        });
    }
}

