/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.ui;

import aurora.ide.AuroraPlugin;
import aurora.ide.search.condition.AttributeCondition;
import aurora.ide.search.condition.ElementCondition;
import aurora.ide.search.condition.NameSpaceCondition;
import aurora.ide.search.condition.SearchCondition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchPageManager {
    private List<SearchCondition> previousSearchNameSpace = new ArrayList<SearchCondition>();
    private List<SearchCondition> previousSearchElement = new ArrayList<SearchCondition>();
    private List<SearchCondition> previousSearchAttribute = new ArrayList<SearchCondition>();
    public static final int HISTORY_SIZE = 12;
    public static final String STORE_NAMESPACE_HISTORY_SIZE = "NAMESPACE_HISTORY_SIZE";
    public static final String STORE_ELEMENT_HISTORY_SIZE = "ELEMENT_HISTORY_SIZE";
    public static final String STORE_ATTRIBUTE_HISTORY_SIZE = "ATTRIBUTE_HISTORY_SIZE";

    public void readConfiguration(String sectionKey, List<SearchCondition> previousList) {
        IDialogSettings s = this.getDialogSettings();
        try {
            int historySize = s.getInt(sectionKey);
            int i = 0;
            while (i < historySize) {
                SearchCondition read;
                SearchCondition condition;
                IDialogSettings histSettings = s.getSection(String.valueOf(sectionKey) + i);
                if (histSettings != null && (condition = this.createSearchCondition(sectionKey)) != null && (read = condition.read(histSettings)) != null) {
                    previousList.add(read);
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private SearchCondition createSearchCondition(String sectionKey) {
        if (STORE_NAMESPACE_HISTORY_SIZE.equals(sectionKey)) {
            return new NameSpaceCondition();
        }
        if (STORE_ELEMENT_HISTORY_SIZE.equals(sectionKey)) {
            return new ElementCondition();
        }
        if (STORE_ATTRIBUTE_HISTORY_SIZE.equals(sectionKey)) {
            return new AttributeCondition();
        }
        return null;
    }

    private IDialogSettings getDialogSettings() {
        return AuroraPlugin.getDefault().getDialogSettingsSection("AuroraSearchPage");
    }

    public void writeConfiguration(String sectionKey, List<SearchCondition> previousList) {
        IDialogSettings s = this.getDialogSettings();
        int historySize = Math.min(previousList.size(), 12);
        s.put(sectionKey, historySize);
        int i = 0;
        while (i < historySize) {
            IDialogSettings histSettings = s.addNewSection(String.valueOf(sectionKey) + i);
            SearchCondition data = previousList.get(i);
            data.store(histSettings);
            ++i;
        }
    }

    public List<SearchCondition> getPreviousSearchNameSpace() {
        return this.previousSearchNameSpace;
    }

    public List<SearchCondition> getPreviousSearchElement() {
        return this.previousSearchElement;
    }

    public List<SearchCondition> getPreviousSearchAttribute() {
        return this.previousSearchAttribute;
    }

    public String[] getPreviousNameSpace() {
        int size = this.previousSearchNameSpace.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            String nameSpace;
            patterns[i] = nameSpace = ((NameSpaceCondition)this.previousSearchNameSpace.get(i)).getNameSpace();
            ++i;
        }
        return patterns;
    }

    public String[] getPreviousElement() {
        int size = this.previousSearchElement.size();
        String[] patterns = new String[size];
        int i = 0;
        while (i < size) {
            patterns[i] = ((ElementCondition)this.previousSearchElement.get(i)).getElementName();
            ++i;
        }
        return patterns;
    }

    public String[] getPreviousAttributeNames() {
        int size = this.previousSearchAttribute.size();
        ArrayList<String> patterns = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            String name = ((AttributeCondition)this.previousSearchAttribute.get(i)).getName();
            if (name != null && !patterns.contains(name)) {
                patterns.add(name);
            }
            ++i;
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    public String[] getPreviousAttributeValues() {
        int size = this.previousSearchAttribute.size();
        ArrayList<String> patterns = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            String value = ((AttributeCondition)this.previousSearchAttribute.get(i)).getValue();
            if (value != null && !patterns.contains(value)) {
                patterns.add(value);
            }
            ++i;
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    public void addPreviousSearchCondition(List<SearchCondition> previousList, SearchCondition condition) {
        Iterator<SearchCondition> iter = previousList.iterator();
        while (iter.hasNext()) {
            SearchCondition sc = iter.next();
            if (!sc.isEquals(condition)) continue;
            iter.remove();
        }
        if (condition != null) {
            previousList.add(0, condition);
        }
    }
}

