/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.screen.custom;

import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.AbstractSearchService;
import aurora.ide.search.core.CompositeMapIteator;
import aurora.ide.search.core.CompositeMapMatch;
import aurora.ide.search.core.Util;
import aurora.ide.search.reference.IDataFilter;
import aurora.ide.search.reference.MapFinderResult;
import aurora.ide.search.reference.ReferenceTypeFinder;
import aurora.ide.search.ui.LineElement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenCustomService
extends AbstractSearchService {
    public ScreenCustomService(IResource scope) {
        super(new IResource[]{scope}, null, null);
    }

    @Override
    protected CompositeMapIteator createIterationHandle(IFile resource) {
        return new ReferenceTypeFinder(datasetReference);
    }

    @Override
    protected IDataFilter getDataFilter(IResource[] roots, Object source) {
        IDataFilter filter = new IDataFilter(){

            public boolean found(CompositeMap map, Attribute attrib) {
                Object object = map.get((Object)"name");
                return "bindTarget".equalsIgnoreCase(attrib.getName()) && object != null && !"".equals(object) && map.get((Object)"id") == null;
            }
        };
        return filter;
    }

    @Override
    protected Object createPattern(IResource[] roots, Object source) {
        return "";
    }

    @Override
    protected List<AbstractMatch> createLineMatches(MapFinderResult r, LineElement l, IFile file, Object pattern) throws CoreException {
        IDocument document = this.getDocument(file);
        int startOffset = l.getOffset();
        ArrayList<AbstractMatch> matches = new ArrayList<AbstractMatch>();
        try {
            IRegion whitespaceRegion = Util.getFirstWhitespaceRegion(startOffset, l.getLength(), document);
            if (whitespaceRegion == null) {
                IRegion attributeRegion = Util.getAttributeRegion(startOffset, l.getLength(), "bindTarget", document);
                whitespaceRegion = new Region(attributeRegion.getOffset() - 1, 0);
            }
            CompositeMapMatch match = new CompositeMapMatch(file, whitespaceRegion.getOffset(), whitespaceRegion.getLength(), r.getMap(), l);
            matches.add(match);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return matches;
    }
}

