/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.reference;

import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.search.core.CompositeMapIteator;
import aurora.ide.search.reference.IDataFilter;
import aurora.ide.search.reference.MapFinderResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.Attribute;
import uncertain.schema.Element;
import uncertain.schema.ISchemaManager;
import uncertain.schema.IType;
import uncertain.schema.SimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceTypeFinder
extends CompositeMapIteator {
    private QualifiedName referenceType;

    public int process(CompositeMap map) {
        try {
            List<Attribute> match = this.getMatch(map);
            if (match != null) {
                this.getResult().add(new MapFinderResult(map, match));
            }
        }
        catch (ApplicationException applicationException) {
            // empty catch block
        }
        return 0;
    }

    protected List<Attribute> getMatch(CompositeMap map) throws ApplicationException {
        ArrayList<Attribute> matchs = new ArrayList<Attribute>();
        boolean isMacth = false;
        Element element = CompositeMapUtil.getElement(map);
        if (element == null) {
            ISchemaManager schemaManager = LoadSchemaManager.getSchemaManager();
            Collection allTypes = schemaManager.getAllTypes();
            for (Object type : allTypes) {
                if (!(type instanceof Element) || !((Element)type).getLocalName().equals(map.getName())) continue;
                element = (Element)type;
            }
        }
        if (element != null) {
            List attrib_list = element.getAllAttributes();
            for (Attribute attrib : attrib_list) {
                IType attributeType = attrib.getAttributeType();
                boolean referenceOf = this.isReferenceType(attributeType);
                if (!referenceOf) continue;
                boolean found = true;
                IDataFilter filter = this.getFilter();
                if (filter != null) {
                    found = filter.found(map, attrib);
                }
                if (!found) continue;
                isMacth = true;
                matchs.add(attrib);
            }
            if (isMacth) {
                return matchs;
            }
        }
        return null;
    }

    protected boolean isReferenceType(IType attributeType) {
        if (attributeType instanceof SimpleType) {
            return this.referenceType.equals((Object)((SimpleType)attributeType).getReferenceTypeQName());
        }
        return false;
    }

    public ReferenceTypeFinder(QualifiedName referenceType) {
        this.referenceType = referenceType;
    }
}

