/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.reference;

import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.CompositeMapIteator;
import aurora.ide.search.reference.MapFinderResult;
import aurora.ide.search.reference.MultiReferenceTypeFinder;
import aurora.ide.search.reference.ReferenceSearchService;
import aurora.ide.search.ui.LineElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.search.ui.ISearchQuery;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSourceReferenceSearchService
extends ReferenceSearchService {
    private List<String> patterns;
    private Map<CompositeMap, List<String>> patternMap = new HashMap<CompositeMap, List<String>>();
    private boolean isBM;
    private IFile[] sources;

    public MultiSourceReferenceSearchService(IResource scope, IFile[] sources, ISearchQuery query, boolean isBM) {
        super(scope, null, query);
        this.sources = sources;
        this.patterns = this.createPatterns(this.getRoots(), sources);
        this.isBM = isBM;
        this.getJsService().getSources().addAll(Arrays.asList(sources));
    }

    private List<String> createPatterns(IResource[] roots, IFile[] sources) {
        ArrayList<String> patterns = new ArrayList<String>();
        IFile[] iFileArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            IFile source = iFileArray[n2];
            Object p = this.createPattern(roots, source);
            if (p instanceof String) {
                patterns.add((String)p);
            }
            ++n2;
        }
        return patterns;
    }

    @Override
    protected CompositeMapIteator createIterationHandle(IFile file) {
        return this.isBM ? new MultiReferenceTypeFinder(bmReference).addReferenceType(urlReference) : new MultiReferenceTypeFinder(screenReference).addReferenceType(urlReference);
    }

    @Override
    protected boolean bmRefMatch(CompositeMap map, Attribute attrib) {
        for (String s : this.patterns) {
            boolean contains = super.bmRefMatch(map, attrib, s);
            if (!contains) continue;
            this.putInPatternMap(map, s);
            return true;
        }
        return false;
    }

    private void putInPatternMap(CompositeMap map, String s) {
        List<String> list = this.patternMap.get(map);
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (!list.contains(s)) {
            list.add(s);
        }
        this.patternMap.put(map, list);
    }

    @Override
    protected boolean screenRefMatch(CompositeMap map, Attribute attrib) {
        IFile findScreenFile = this.findScreenFile(map, attrib);
        int indexOf = Arrays.asList(this.sources).indexOf(findScreenFile);
        if (indexOf != -1) {
            this.putInPatternMap(map, this.createPattern(this.getRoots(), this.sources[indexOf]).toString());
            return true;
        }
        return false;
    }

    @Override
    public boolean found(CompositeMap map, Attribute attrib) {
        if (attrib == null) {
            return false;
        }
        return this.isBM ? this.bmRefMatch(map, attrib) : this.screenRefMatch(map, attrib);
    }

    @Override
    protected List<AbstractMatch> createLineMatches(MapFinderResult r, LineElement l, IFile file, Object pattern) throws CoreException {
        List<String> ps = this.patternMap.get(r.getMap());
        if (ps != null) {
            ArrayList<AbstractMatch> result = new ArrayList<AbstractMatch>();
            for (String s : ps) {
                result.addAll(super.createLineMatches(r, l, file, s));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    protected Object createPattern(IResource[] roots, Object source) {
        if (source == null) {
            return "Aurora Multi-References";
        }
        return super.createPattern(roots, source);
    }
}

