/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.reference;

import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.search.core.CompositeMapIteator;
import aurora.ide.search.core.Util;
import aurora.ide.search.reference.IDataFilter;
import aurora.ide.search.reference.ReferenceSearchService;
import aurora.ide.search.reference.ReferenceTypeFinder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.search.ui.ISearchQuery;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.Attribute;
import uncertain.schema.IType;
import uncertain.schema.SimpleType;

public class BMFieldReferenceService
extends ReferenceSearchService {
    private String fieldName;
    private String bmPkg;
    private IResource scope;

    public BMFieldReferenceService(IResource scope, Object source, ISearchQuery query, String fieldName) {
        super(scope, source, query);
        this.fieldName = fieldName;
        this.scope = scope;
        this.setSupportJS(false);
    }

    protected CompositeMapIteator createIterationHandle(IFile resource) {
        return new BMFieldReferenceTypeFinder(bmReference);
    }

    protected IDataFilter getDataFilter(IResource[] roots, final Object source) {
        IDataFilter filter = new IDataFilter(){

            public boolean found(CompositeMap map, Attribute attrib) {
                boolean isLocal = this.isLocalRef(attrib);
                if (isLocal) {
                    return this.localFieldFilter(map, attrib);
                }
                return this.foreignFieldFilter(map, attrib);
            }

            private boolean foreignFieldFilter(CompositeMap map, Attribute attrib) {
                boolean isRef = this.isReferenceModel(map.getParent());
                if (isRef) {
                    return this.isMatch(BMFieldReferenceService.this.scope, source, map, attrib);
                }
                if (this.isReferenceModel(map.getParent().getParent())) {
                    return this.isMatch(BMFieldReferenceService.this.scope, source, map, attrib);
                }
                return false;
            }

            private boolean isReferenceModel(CompositeMap parent) {
                Object pkg = Util.getReferenceModelPKG(parent);
                return BMFieldReferenceService.this.bmPkg == null ? false : BMFieldReferenceService.this.bmPkg.equals(pkg);
            }

            private boolean localFieldFilter(CompositeMap map, Attribute attrib) {
                CompositeMap root = map.getRoot();
                IFile file = BMFieldReferenceService.this.getFile(root);
                if (file.equals(source)) {
                    return this.isMatch(BMFieldReferenceService.this.scope, source, map, attrib);
                }
                return false;
            }

            private boolean isMatch(IResource scope, Object source2, CompositeMap map, Attribute attrib) {
                Object pattern = BMFieldReferenceService.this.getSearchPattern(new IResource[]{scope}, source2);
                String data = CompositeMapUtil.getValueIgnoreCase(attrib, map);
                return pattern == null ? false : pattern.equals(data);
            }

            protected boolean isLocalRef(Attribute attrib) {
                IType attributeType = attrib.getAttributeType();
                if (attributeType instanceof SimpleType) {
                    QualifiedName referenceTypeQName = ((SimpleType)attributeType).getReferenceTypeQName();
                    return localFieldReference.equals((Object)referenceTypeQName);
                }
                return false;
            }
        };
        return filter;
    }

    protected Object createPattern(IResource[] roots, Object source) {
        this.bmPkg = (String)super.createPattern(roots, source);
        return this.fieldName;
    }

    private class BMFieldReferenceTypeFinder
    extends ReferenceTypeFinder {
        public BMFieldReferenceTypeFinder(QualifiedName referenceType) {
            super(referenceType);
        }

        protected boolean isReferenceType(IType attributeType) {
            if (attributeType instanceof SimpleType) {
                QualifiedName referenceTypeQName = ((SimpleType)attributeType).getReferenceTypeQName();
                return foreignFieldReference.equals((Object)referenceTypeQName) || localFieldReference.equals((Object)referenceTypeQName);
            }
            return false;
        }
    }
}

