/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.core;

import aurora.ide.search.core.AbstractSearchQuery;
import aurora.ide.search.core.AbstractSearchService;
import aurora.ide.search.reference.BMFieldReferenceQuery;
import aurora.ide.search.reference.FileReferenceQuery;
import aurora.ide.search.reference.ScreenDSReferenceQuery;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import uncertain.composite.QualifiedName;

public class SearchQueryFactory {
    public static AbstractSearchQuery createSearchQuery(QualifiedName referenceTypeQName, IResource scope, IFile sourceFile, String fieldName) {
        if (AbstractSearchService.foreignFieldReference.equals((Object)referenceTypeQName)) {
            return SearchQueryFactory.createBMFieldReferenceQuery(scope, sourceFile, fieldName);
        }
        if (AbstractSearchService.localFieldReference.equals((Object)referenceTypeQName)) {
            return SearchQueryFactory.createBMFieldReferenceQuery(scope, sourceFile, fieldName);
        }
        if (AbstractSearchService.bmReference.equals((Object)referenceTypeQName)) {
            return SearchQueryFactory.createBMReferenceQuery(scope, sourceFile, fieldName);
        }
        if (AbstractSearchService.screenReference.equals((Object)referenceTypeQName)) {
            return SearchQueryFactory.createBMReferenceQuery(scope, sourceFile, fieldName);
        }
        if (AbstractSearchService.datasetReference.equals((Object)referenceTypeQName)) {
            return SearchQueryFactory.createDSReferenceQuery(scope, sourceFile, fieldName);
        }
        return null;
    }

    private static AbstractSearchQuery createDSReferenceQuery(IResource scope, IFile sourceFile, String fieldName) {
        return new ScreenDSReferenceQuery(scope, sourceFile, fieldName);
    }

    private static AbstractSearchQuery createBMReferenceQuery(IResource scope, IFile sourceFile, String fieldName) {
        return new FileReferenceQuery(scope, sourceFile);
    }

    private static AbstractSearchQuery createBMFieldReferenceQuery(IResource scope, IFile sourceFile, String fieldName) {
        return new BMFieldReferenceQuery(scope, sourceFile, fieldName);
    }
}

