/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.core;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapLocatorParser;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.SystemException;
import aurora.ide.search.core.CompositeMapInDocument;
import aurora.ide.search.core.NoNamespaceMapParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeMap;

public class CompositeMapInDocumentManager {
    public static CompositeMapInDocument getCompositeMapInDocument(CompositeMap map, IDocument document) {
        int startLine = map.getLocation().getStartLine() - 1;
        int endLine = map.getLocation().getEndLine() - 1;
        try {
            IRegion sInfo = document.getLineInformation(startLine);
            IRegion eInfo = document.getLineInformation(endLine);
            ITypedRegion[] sPartitions = document.computePartitioning(sInfo.getOffset(), sInfo.getLength());
            ITypedRegion[] ePartitions = document.computePartitioning(eInfo.getOffset(), eInfo.getLength());
            ITypedRegion[] iTypedRegionArray = sPartitions;
            int n = sPartitions.length;
            int n2 = 0;
            while (n2 < n) {
                Map namspaceMapping;
                CompositeMapInDocument _info;
                ITypedRegion p = iTypedRegionArray[n2];
                if ("XML_START_TAG".equals(p.getType()) && (_info = CompositeMapInDocumentManager.lookupCompositeMap(namspaceMapping = map.getRoot().equals((Object)map) ? null : map.getRoot().getNamespaceMapping(), p, ePartitions, document)) != null) {
                    CompositeMap map2 = _info.getMap();
                    ((CommentCompositeMap)map2).setComment(((CommentCompositeMap)map).getComment());
                    if (map.getName().equals(map2.getName()) && map.getName().equals(map.getRawName()) && map.getRawName().equals(map2.getRawName()) && map2.getNamespaceURI() == null) {
                        map2.setNameSpaceURI(map.getNamespaceURI());
                    }
                    if (map.equals((Object)map2)) {
                        return _info;
                    }
                }
                ++n2;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private static CompositeMapInDocument lookupCompositeMap(Map namespaceMapping, ITypedRegion start, ITypedRegion[] ends, IDocument document) {
        try {
            String _xml = document.get(start.getOffset(), start.getLength());
            CompositeMap map = CompositeMapInDocumentManager.loaderFromString(namespaceMapping, _xml);
            if (map != null) {
                CompositeMapInDocument info = new CompositeMapInDocument(map, document, (IRegion)start, (IRegion)start);
                return info;
            }
        }
        catch (BadLocationException _xml) {
        }
        catch (ApplicationException _xml) {
            // empty catch block
        }
        ITypedRegion[] iTypedRegionArray = ends;
        int n = ends.length;
        int n2 = 0;
        while (n2 < n) {
            ITypedRegion p = iTypedRegionArray[n2];
            if ("XML_END_TAG".equals(p.getType())) {
                try {
                    String _xml = document.get(start.getOffset(), p.getOffset() + p.getLength() - start.getOffset());
                    CompositeMap map = CompositeMapInDocumentManager.loaderFromString(namespaceMapping, _xml);
                    if (map != null) {
                        CompositeMapInDocument info = new CompositeMapInDocument(map, document, (IRegion)start, (IRegion)p);
                        return info;
                    }
                }
                catch (BadLocationException _xml) {
                }
                catch (ApplicationException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return null;
    }

    public static CompositeMap loaderFromString(Map namespaceMapping, String content) throws ApplicationException {
        if (namespaceMapping == null) {
            return CompositeMapUtil.loaderFromString(content);
        }
        if (content == null) {
            return null;
        }
        CompositeMap root = null;
        NoNamespaceMapParser parser = new NoNamespaceMapParser(namespaceMapping);
        InputStream is = null;
        try {
            try {
                is = new ByteArrayInputStream(content.getBytes("UTF-8"));
                root = ((CompositeMapLocatorParser)parser).parseStream(is);
            }
            catch (UnsupportedEncodingException e) {
                throw new SystemException(e);
            }
            catch (SAXException e) {
                throw new ApplicationException("\u8bf7\u68c0\u67e5\u5185\u5bb9\u683c\u5f0f" + content + "\u662f\u5426\u6b63\u786e.", e);
            }
            catch (IOException e) {
                throw new ApplicationException("\u8bf7\u68c0\u67e5\u5185\u5bb9\u683c\u5f0f" + content + "\u662f\u5426\u6b63\u786e.", e);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    DialogUtil.logErrorException(e);
                }
            }
        }
        return root;
    }
}

