/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.core;

import aurora.ide.helpers.ApplicationException;
import aurora.ide.javascript.search.Javascript4RhinoSearchService;
import aurora.ide.javascript.search.JavascriptSearchService;
import aurora.ide.search.cache.CacheManager;
import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.AbstractSearchResult;
import aurora.ide.search.core.AuroraFileFinder;
import aurora.ide.search.core.AuroraMatch;
import aurora.ide.search.core.CompositeMapIteator;
import aurora.ide.search.core.ISearchService;
import aurora.ide.search.core.MultiIteatorMapFinder;
import aurora.ide.search.core.Util;
import aurora.ide.search.reference.IDataFilter;
import aurora.ide.search.reference.MapFinderResult;
import aurora.ide.search.ui.LineElement;
import aurora.ide.search.ui.MessageFormater;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import uncertain.composite.CompositeMap;
import uncertain.composite.IterationHandle;
import uncertain.composite.QualifiedName;
import uncertain.schema.Attribute;
import uncertain.util.resource.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSearchService
implements ISearchService {
    public static final QualifiedName bmReference = new QualifiedName("http://www.aurora-framework.org/schema/bm", "model");
    public static final QualifiedName screenReference = new QualifiedName("http://www.aurora-framework.org/application", "screen");
    public static final QualifiedName localFieldReference = new QualifiedName("http://www.aurora-framework.org/schema/bm", "localField");
    public static final QualifiedName foreignFieldReference = new QualifiedName("http://www.aurora-framework.org/schema/bm", "foreignField");
    public static final QualifiedName datasetReference = new QualifiedName("http://www.aurora-framework.org/application", "dataset");
    public static final QualifiedName urlReference = new QualifiedName("http://www.aurora-framework.org/application", "screenBm");
    private Map<CompositeMap, IResource> compositeMap = new HashMap<CompositeMap, IResource>();
    private Map<IFile, Exception> exceptionMap = new HashMap<IFile, Exception>();
    private JavascriptSearchService jsService;
    private boolean runInUI = false;
    private Object pattern;
    private boolean isPostException = true;
    private ISearchQuery query;
    private Object source;
    private IResource[] roots;
    private IFile fCurrentFile;
    private int fNumberOfScannedFiles;
    private int fNumberOfFilesToScan;
    private boolean supportJS;

    public JavascriptSearchService getJsService() {
        return this.jsService;
    }

    public boolean isPostException() {
        return this.isPostException;
    }

    public void setPostException(boolean isPostException) {
        this.isPostException = isPostException;
    }

    public void setSupportJS(boolean supportJS) {
        this.supportJS = supportJS;
    }

    public AbstractSearchService(IResource[] roots, Object source) {
        this.roots = roots;
        this.source = source;
        this.jsService = new Javascript4RhinoSearchService();
        if (source instanceof IFile) {
            this.jsService.addSource((IFile)source);
        }
    }

    public AbstractSearchService(IResource[] roots, Object source, ISearchQuery query) {
        this(roots, source);
        this.query = query;
    }

    protected abstract CompositeMapIteator createIterationHandle(IFile var1);

    protected List<AbstractMatch> buildMatchLines(IFile file, List<MapFinderResult> r, Object pattern) throws CoreException {
        ArrayList<AbstractMatch> lines = new ArrayList<AbstractMatch>();
        if (this.isSupportJS()) {
            lines.addAll(this.jsService.buildMatchLines(file, r, pattern));
        }
        int i = 0;
        while (i < r.size()) {
            MapFinderResult result = r.get(i);
            CompositeMap map = result.getMap();
            Location location = map.getLocation();
            IDocument document = this.getDocument(file);
            int lineNo = location.getStartLine();
            LineElement l = null;
            try {
                IRegion lineInformation = document.getLineInformation(lineNo - 1);
                String lineContent = document.get(lineInformation.getOffset(), lineInformation.getLength());
                l = new LineElement((IResource)file, lineNo, lineInformation.getOffset(), lineContent);
                lines.addAll(this.createLineMatches(result, l, file, pattern));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            ++i;
        }
        return lines;
    }

    private List<AbstractMatch> processFile(IResource resource) throws CoreException, ApplicationException {
        ArrayList<AbstractMatch> result = new ArrayList<AbstractMatch>();
        ++this.fNumberOfScannedFiles;
        CompositeMapIteator finder = this.createIterationHandle((IFile)resource);
        if (this.isSupportJS()) {
            finder = new MultiIteatorMapFinder().addFinder(this.jsService.createIterationHandle((IFile)resource)).addFinder(finder);
        }
        finder.setFilter(this.getDataFilter(this.roots, this.source));
        CompositeMap bm = this.getCompositeMap((IFile)resource);
        this.compositeMap.put(bm, resource);
        bm.iterate((IterationHandle)finder, true);
        List<MapFinderResult> r = finder.getResult();
        List<AbstractMatch> lines = this.buildMatchLines((IFile)resource, r, this.pattern);
        int i = 0;
        while (i < lines.size()) {
            if (this.query != null) {
                ISearchResult searchResult = this.query.getSearchResult();
                if (searchResult instanceof AbstractSearchResult) {
                    ((AbstractSearchResult)searchResult).addMatch(lines.get(i));
                }
            } else {
                result.add(lines.get(i));
            }
            ++i;
        }
        return result;
    }

    private boolean isSupportJS() {
        return this.supportJS;
    }

    protected List<AbstractMatch> createLineMatches(MapFinderResult r, LineElement l, IFile file, Object pattern) throws CoreException {
        IDocument document = this.getDocument(file);
        FindReplaceDocumentAdapter dd = new FindReplaceDocumentAdapter(this.getDocument(file));
        ArrayList<AbstractMatch> matches = new ArrayList<AbstractMatch>();
        List<Attribute> attributes = r.getAttributes();
        if (attributes == null) {
            return matches;
        }
        int i = 0;
        while (i < attributes.size()) {
            try {
                IRegion valueRegion;
                int startOffset = l.getOffset();
                Attribute att = attributes.get(i);
                String name = att.getName();
                IRegion nameRegion = this.getAttributeRegion(startOffset, l.getLength(), name, document);
                if (nameRegion != null && (valueRegion = dd.find(startOffset = nameRegion.getOffset(), pattern.toString(), true, true, true, false)) != null) {
                    startOffset = valueRegion.getOffset();
                    AuroraMatch match = new AuroraMatch(file, valueRegion.getOffset(), valueRegion.getLength(), l);
                    match.setMatchs(r);
                    matches.add(match);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            ++i;
        }
        return matches;
    }

    protected IRegion getAttributeRegion(int offset, int length, String name, IDocument document) throws BadLocationException {
        IRegion attributeRegion = Util.getAttributeRegion(offset, length, name, document);
        return attributeRegion;
    }

    @Override
    public List<AbstractMatch> service(final IProgressMonitor monitor) {
        ArrayList<AbstractMatch> result;
        block11: {
            List<IResource> files = this.findFilesInScopes(this.roots);
            this.fNumberOfFilesToScan = files.size();
            Job monitorUpdateJob = new Job("Aurora Search progress"){
                private int fLastNumberOfScannedFiles;
                {
                    super($anonymous0);
                    this.fLastNumberOfScannedFiles = 0;
                }

                public IStatus run(IProgressMonitor inner) {
                    while (!inner.isCanceled()) {
                        final IFile file = AbstractSearchService.this.fCurrentFile;
                        if (file != null) {
                            if (AbstractSearchService.this.isRunInUI()) {
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        this.updateMonitor(monitor, file);
                                    }
                                });
                            } else {
                                this.updateMonitor(monitor, file);
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            return Status.OK_STATUS;
                        }
                    }
                    return Status.OK_STATUS;
                }

                private void updateMonitor(IProgressMonitor monitor2, IFile file) {
                    String fileName = file.getName();
                    Object[] args = new Object[]{fileName, new Integer(AbstractSearchService.this.fNumberOfScannedFiles), new Integer(AbstractSearchService.this.fNumberOfFilesToScan)};
                    monitor2.subTask(MessageFormater.format("Scanning file {1} of {2}: {0}", args));
                    int steps = AbstractSearchService.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                    monitor2.worked(steps);
                    this.fLastNumberOfScannedFiles += steps;
                }
            };
            this.pattern = this.getSearchPattern(this.roots, this.source);
            monitor.beginTask("Searching for " + this.pattern.toString(), files.size());
            monitorUpdateJob.setSystem(true);
            monitorUpdateJob.schedule();
            result = new ArrayList<AbstractMatch>();
            try {
                if (files == null) break block11;
                int i = 0;
                while (i < files.size()) {
                    if (monitor.isCanceled()) {
                        ArrayList<AbstractMatch> arrayList = result;
                        return arrayList;
                    }
                    this.fCurrentFile = (IFile)files.get(i);
                    try {
                        result.addAll(this.processFile((IResource)this.fCurrentFile));
                    }
                    catch (CoreException coreException) {
                    }
                    catch (ApplicationException applicationException) {
                    }
                    catch (Exception e) {
                        boolean cfr_ignored_0 = e instanceof IllegalArgumentException;
                        e.printStackTrace();
                        this.handleException(this.fCurrentFile, e);
                    }
                    ++i;
                }
            }
            finally {
                monitorUpdateJob.cancel();
                monitor.done();
                if (this.isPostException) {
                    this.postException();
                }
            }
        }
        return result;
    }

    private static Shell getShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchWindow windowToParentOn = activeWindow == null ? (workbench.getWorkbenchWindowCount() > 0 ? workbench.getWorkbenchWindows()[0] : null) : activeWindow;
        return windowToParentOn == null ? null : activeWindow.getShell();
    }

    private static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void postException() {
        if (this.exceptionMap.size() != 0) {
            AbstractSearchService.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MultiStatus status = new MultiStatus("aurora.ide", 4, AbstractSearchService.this.getStatusChildren(), "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38", null);
                    ErrorDialog.openError((Shell)AbstractSearchService.getShell(), null, null, (IStatus)status);
                }
            });
        }
    }

    public IStatus[] getStatusChildren() {
        IStatus[] children = new IStatus[this.exceptionMap.size()];
        Set<IFile> keySet = this.exceptionMap.keySet();
        int i = 0;
        for (IFile o : keySet) {
            children[i] = new Status(4, "aurora.ide", o.getFullPath().toString(), (Throwable)this.exceptionMap.get(o));
            ++i;
        }
        return children;
    }

    private void handleException(IFile file, Exception e) {
        this.exceptionMap.put(file, e);
    }

    private List<IResource> findFilesInScopes(IResource[] roots) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        if (roots != null) {
            int i = 0;
            while (i < roots.length) {
                List<IResource> _result = this.findFilesInScope(roots[i]);
                this.merge(result, _result);
                ++i;
            }
        }
        return result;
    }

    private void merge(List<IResource> to, List<IResource> from) {
        if (from == null) {
            return;
        }
        int i = 0;
        while (i < from.size()) {
            if (!to.contains(from.get(i))) {
                to.add(from.get(i));
            }
            ++i;
        }
    }

    private List<IResource> findFilesInScope(IResource scope) {
        AuroraFileFinder visitor = new AuroraFileFinder();
        try {
            scope.accept((IResourceVisitor)visitor);
            return visitor.getResult();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected abstract IDataFilter getDataFilter(IResource[] var1, Object var2);

    public Object getSearchPattern(IResource[] roots, Object source) {
        return this.pattern == null ? this.createPattern(roots, source) : this.pattern;
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public Object getSource() {
        return this.source;
    }

    public IResource[] getRoots() {
        return this.roots;
    }

    public CompositeMap getCompositeMap(IFile file) throws CoreException, ApplicationException {
        return CacheManager.getCompositeMapCacher().getCompositeMap(file);
    }

    public IFile getFile(CompositeMap map) {
        return (IFile)this.compositeMap.get(map);
    }

    public IDocument getDocument(IFile file) throws CoreException {
        return CacheManager.getDocument(file);
    }

    protected abstract Object createPattern(IResource[] var1, Object var2);

    public boolean isRunInUI() {
        return this.runInUI;
    }

    public void setRunInUI(boolean runInUI) {
        this.runInUI = runInUI;
    }
}

