/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.condition;

import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.search.condition.MatchInfo;
import aurora.ide.search.condition.SearchCondition;
import aurora.ide.search.core.Util;
import aurora.ide.search.ui.LineElement;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import uncertain.composite.CompositeMap;

public class ElementCondition
extends SearchCondition {
    private String elementName;

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public SearchCondition read(IDialogSettings s) {
        this.setCaseSensitive(s.getBoolean("isCaseSensitive"));
        this.setElementName(s.get("elementName"));
        return this;
    }

    public MatchInfo match(CompositeMap map, IDocument document, LineElement l) {
        if ("".equals(this.elementName)) {
            return MatchInfo.Not_Match;
        }
        boolean stringMatch = Util.stringMatch(this.elementName, map.getName(), this.isCaseSensitive(), this.isRegularExpression());
        if (stringMatch) {
            MatchInfo info = new MatchInfo();
            String rawName = map.getRawName();
            info.setMap(map);
            try {
                IRegion documentRegion = Util.getDocumentRegion(l.getOffset(), l.getLength(), rawName, document, IColorConstants.TAG_NAME);
                info.addRegion(documentRegion);
                return info;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return MatchInfo.Not_Match;
    }

    public void store(IDialogSettings s) {
        s.put("isCaseSensitive", this.isCaseSensitive());
        if (this.elementName != null) {
            s.put("elementName", this.elementName);
        }
    }

    public boolean isEquals(SearchCondition condition) {
        if (condition instanceof ElementCondition) {
            String _name = this.elementName == null ? "" : this.elementName;
            return _name.equals(((ElementCondition)condition).elementName);
        }
        return super.isEquals(condition);
    }
}

