/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.cache;

import aurora.ide.helpers.ApplicationException;
import aurora.ide.search.cache.CompositeMapCacher;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import uncertain.composite.CompositeMap;

public class CacheManager {
    private static CompositeMapCacher mapCacher;
    private static final String POINT_ID = "aurora.ide.compositeMapCacher";
    private static List<String> exs;

    static {
        exs = new ArrayList<String>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(POINT_ID);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configurationElements;
                IConfigurationElement[] iConfigurationElementArray = configurationElements = extensions[i].getConfigurationElements();
                int n = configurationElements.length;
                int n2 = 0;
                while (n2 < n) {
                    String attribute;
                    IConfigurationElement ice = iConfigurationElementArray[n2];
                    if ("files".equals(ice.getName()) && (attribute = ice.getAttribute("extentionNames")) != null) {
                        String[] split;
                        String[] stringArray = split = attribute.split(",");
                        int n3 = split.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String s = stringArray[n4];
                            exs.add(s.trim().toLowerCase());
                            ++n4;
                        }
                    }
                    ++n2;
                }
                ++i;
            }
        }
    }

    public static boolean isSupport(String ext) {
        return exs.contains(ext.toLowerCase());
    }

    public static boolean isSupport(IFile file) {
        return CacheManager.isSupport(file.getFileExtension());
    }

    public static final CompositeMapCacher getCompositeMapCacher() {
        if (mapCacher == null) {
            mapCacher = new CompositeMapCacher();
        }
        return mapCacher;
    }

    public static CompositeMap getCompositeMap(IFile file) throws CoreException, ApplicationException {
        return CacheManager.getCompositeMapCacher().getCompositeMap(file);
    }

    public static CompositeMap getWholeBMCompositeMap(IFile file) throws CoreException, ApplicationException {
        return CacheManager.getCompositeMapCacher().getWholeCompositeMap(file);
    }

    public static IDocument getDocument(IFile file) throws CoreException {
        return CacheManager.getCompositeMapCacher().getDocument(file);
    }

    public static String getTOXML(IFile file) throws CoreException, ApplicationException {
        return CacheManager.getCompositeMapCacher().getTOXML(file);
    }

    public static String getString(IFile file) throws CoreException, ApplicationException {
        return CacheManager.getCompositeMapCacher().getString(file);
    }
}

